/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.particle.StormwardParticles;

public class RainsprenParticle
extends TextureSheetParticle {
    RainsprenParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ);
        this.m_107250_(0.01f, 0.01f);
        this.f_107226_ = 0.002f;
        this.f_107663_ *= 0.75f;
        this.m_107253_(0.227451f, 0.560784f, 1.0f);
        this.m_108339_(pSprites);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.preMoveUpdate();
        if (!this.f_107220_) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.postMoveUpdate();
            if (!this.f_107220_) {
                this.f_107215_ *= 0.98;
                this.f_107216_ *= 0.98;
                this.f_107217_ *= 0.98;
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void postMoveUpdate() {
    }

    public static class FlameProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public FlameProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            FlameParticle particle = new FlameParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            particle.m_108335_(this.sprite);
            return particle;
        }
    }

    public static class LandProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public LandProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new DripLandParticle(pLevel, pX, pY, pZ, this.sprite);
        }
    }

    public static class FallProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public FallProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new FallAndLandParticle(pLevel, pX, pY, pZ, this.sprite, (ParticleOptions)StormwardParticles.LANDING_RAINSPREN.get());
        }
    }

    static class FlameParticle
    extends RisingParticle {
        FlameParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
            this.m_6569_(0.5f);
        }

        @NotNull
        public ParticleRenderType m_7556_() {
            return ParticleRenderType.f_107430_;
        }

        public void m_6257_(double pX, double pY, double pZ) {
            this.m_107259_(this.m_107277_().m_82386_(pX, pY, pZ));
            this.m_107275_();
        }

        public float m_5902_(float pScaleFactor) {
            float f = ((float)this.f_107224_ + pScaleFactor) / (float)this.f_107225_;
            return this.f_107663_ * (1.0f - f * f * 0.5f);
        }

        public int m_6355_(float pPartialTick) {
            float f = ((float)this.f_107224_ + pPartialTick) / (float)this.f_107225_;
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            int i = super.m_6355_(pPartialTick);
            int j = i & 0xFF;
            int k = i >> 16 & 0xFF;
            if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
                j = 240;
            }
            return j | k << 16;
        }
    }

    static class DripLandParticle
    extends RainsprenParticle {
        DripLandParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet pSprites) {
            super(pLevel, pX, pY, pZ, pSprites);
            this.f_107225_ = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    static class FallAndLandParticle
    extends FallingParticle {
        protected final ParticleOptions landParticle;

        FallAndLandParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet pSprites, ParticleOptions pLandParticle) {
            super(pLevel, pX, pY, pZ, pSprites);
            this.landParticle = pLandParticle;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
    }

    static class FallingParticle
    extends RainsprenParticle {
        FallingParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet pSprites) {
            this(pLevel, pX, pY, pZ, (int)(64.0 / (Math.random() * 0.8 + 0.2)), pSprites);
        }

        FallingParticle(ClientLevel pLevel, double pX, double pY, double pZ, int pLifetime, SpriteSet pSprites) {
            super(pLevel, pX, pY, pZ, pSprites);
            this.f_107225_ = pLifetime;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
            }
        }
    }
}

