/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RoarParticle
extends TextureSheetParticle {
    private final Quaternionf rotation;

    protected RoarParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXRot, double pYRot) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        this.f_107663_ = 2.4f;
        this.f_107225_ = 20;
        this.f_107226_ = 0.0f;
        double dist = Math.cos(pXRot);
        this.f_107215_ = -Math.sin(pYRot) * dist * 0.3;
        this.f_107216_ = Math.sin(pXRot) * 0.3;
        this.f_107217_ = Math.cos(pYRot) * dist * 0.3;
        this.rotation = new Quaternionf().rotateY(-((float)pYRot)).rotateX(-((float)pXRot));
    }

    public float m_5902_(float pScaleFactor) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + pScaleFactor) / (float)this.f_107225_ * 0.75f), (float)0.0f, (float)1.0f);
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        this.f_107230_ = 1.0f - Mth.m_14036_((float)(((float)this.f_107224_ + pPartialTicks) / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        this.renderRotatedParticle(pBuffer, pRenderInfo, pPartialTicks, quaternion -> {});
        this.renderRotatedParticle(pBuffer, pRenderInfo, pPartialTicks, quaternion -> quaternion.mul((Quaternionfc)new Quaternionf().rotateY((float)(-Math.PI))));
    }

    private void renderRotatedParticle(VertexConsumer pConsumer, Camera pCamera, float pPartialTick, Consumer<Quaternionf> pRotConsumer) {
        Vec3 vec3 = pCamera.m_90583_();
        float f = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf localRotation = this.rotation;
        pRotConsumer.accept(localRotation);
        Vector3f[] coords = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.m_5902_(pPartialTick);
        for (int i = 0; i < 4; ++i) {
            Vector3f coord = coords[i];
            coord.rotate((Quaternionfc)localRotation);
            coord.mul(f3);
            coord.add(f, f1, f2);
        }
        int lightColor = this.m_6355_(pPartialTick);
        this.makeCornerVertex(pConsumer, coords[0], this.m_5952_(), this.m_5950_(), lightColor);
        this.makeCornerVertex(pConsumer, coords[1], this.m_5952_(), this.m_5951_(), lightColor);
        this.makeCornerVertex(pConsumer, coords[2], this.m_5970_(), this.m_5951_(), lightColor);
        this.makeCornerVertex(pConsumer, coords[3], this.m_5970_(), this.m_5950_(), lightColor);
    }

    private void makeCornerVertex(VertexConsumer pConsumer, Vector3f pVertex, float pU, float pV, int pPackedLight) {
        pConsumer.m_5483_((double)pVertex.x(), (double)pVertex.y(), (double)pVertex.z()).m_7421_(pU, pV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(pPackedLight).m_5752_();
    }

    public int m_6355_(float pPartialTick) {
        return 240;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            RoarParticle particle = new RoarParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed);
            particle.m_108335_(this.sprites);
            particle.m_107271_(1.0f);
            return particle;
        }
    }
}

