/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class SprenParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final boolean setSpriteFromAge;

    SprenParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites, boolean pSetSpriteFromAge) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        this.sprites = pSprites;
        this.setSpriteFromAge = pSetSpriteFromAge;
        this.f_107215_ = pXSpeed * (Math.random() * 2.0 - 1.0);
        this.f_107216_ = pYSpeed * (Math.random() * 2.0 - 1.0);
        this.f_107217_ = pZSpeed * (Math.random() * 2.0 - 1.0);
        this.f_107219_ = false;
        if (pSetSpriteFromAge) {
            this.m_108339_(pSprites);
        } else {
            this.m_108335_(pSprites);
        }
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.setSpriteFromAge) {
            this.m_108339_(this.sprites);
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class FearsprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public FearsprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            ShrinkParticle particle = new ShrinkParticle(pLevel, pX, pY, pZ, 0.01, 0.01, 0.01, this.sprite, false);
            particle.m_107257_(20 + (int)(Math.random() * 10.0));
            ((SprenParticle)particle).f_172258_ = 0.96f;
            return particle;
        }
    }

    public static class StarsprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public StarsprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            UnlitParticle particle = new UnlitParticle(pLevel, pX, pY, pZ, 0.01, 0.01, 0.01, this.sprite, true);
            ((SprenParticle)particle).f_107663_ *= 0.75f;
            particle.m_107253_(1.0f, 0.949019f, 0.729412f);
            particle.m_107257_(6);
            return particle;
        }
    }

    public static class RiversprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public RiversprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            AshParticle particle = new AshParticle(pLevel, pX, pY, pZ, 0.005, 0.005, 0.005, this.sprite);
            particle.m_107257_(20 + (int)(Math.random() * 12.0));
            particle.m_107253_(0.141176f, 0.121568f, 0.509804f);
            ((SprenParticle)particle).f_107663_ *= 0.625f;
            return particle;
        }
    }

    public static class MusicsprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public MusicsprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            SprenParticle particle = new SprenParticle(pLevel, pX, pY, pZ, 0.03, 0.03, 0.03, this.sprite, false);
            particle.m_107257_(10 + (int)(Math.random() * 8.0));
            particle.m_107253_((float)pXSpeed, (float)pYSpeed, (float)pZSpeed);
            particle.f_107226_ = 0.1f;
            return particle;
        }
    }

    public static class HungersprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public HungersprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            AshParticle particle = new AshParticle(pLevel, pX, pY, pZ, 0.03, 0.03, 0.03, this.sprite);
            particle.m_107257_(12 + (int)(Math.random() * 8.0));
            return particle;
        }
    }

    public static class ColdsprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public ColdsprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            SparkleParticle particle = new SparkleParticle(pLevel, pX, pY, pZ, this.sprite, true);
            particle.m_107257_(10 + (int)(Math.random() * 4.0));
            particle.m_107253_(0.784314f, 0.862745f, 1.0f);
            return particle;
        }
    }

    public static class GlorysprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public GlorysprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            AuraParticle particle = new AuraParticle(pLevel, pX, pY, pZ, this.sprite, false);
            particle.m_107257_(12 + (int)(Math.random() * 8.0));
            return particle;
        }
    }

    public static class PainsprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public PainsprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            SprenParticle particle = new SprenParticle(pLevel, pX, pY, pZ, 0.01, 0.0, 0.01, this.sprite, false);
            particle.f_107216_ = Math.random() * 2.0 * (double)0.01f;
            particle.m_107257_(16 + (int)(Math.random() * 8.0));
            particle.m_107253_(0.768627f, 0.486274f, 0.121568f);
            particle.f_172258_ = 0.96f;
            particle.f_107663_ *= 0.75f;
            return particle;
        }
    }

    public static class RocksprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public RocksprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            AshParticle particle = new AshParticle(pLevel, pX, pY, pZ, 0.01, 0.0, 0.01, this.sprite);
            particle.m_107257_(12 + (int)(Math.random() * 4.0));
            particle.m_107253_(0.513725f, 0.388235f, 0.337255f);
            ((SprenParticle)particle).f_107226_ = 0.06f;
            return particle;
        }
    }

    public static class PassionsprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public PassionsprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            FadeParticle particle = new FadeParticle(pLevel, pX, pY, pZ, 0.01, 0.0, 0.01, this.sprite, false);
            particle.m_107257_(28 + (int)(Math.random() * 16.0));
            ((SprenParticle)particle).f_107226_ = 0.02f;
            return particle;
        }
    }

    public static class LifesprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public LifesprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            UnlitAshParticle particle = new UnlitAshParticle(pLevel, pX, pY, pZ, 0.01, 0.01, 0.01, this.sprite);
            particle.m_107257_(28 + (int)(Math.random() * 16.0));
            particle.m_107253_(0.321568f, 0.866666f, 0.301961f);
            ((SprenParticle)particle).f_172258_ = 0.96f;
            return particle;
        }
    }

    public static class LogicsprenBoltProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public LogicsprenBoltProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            UnlitParticle particle = new UnlitParticle(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0, this.sprite, true);
            particle.m_107257_(3);
            ((SprenParticle)particle).m_107271_(0.75f);
            ((SprenParticle)particle).f_107663_ *= 0.75f;
            return particle;
        }
    }

    public static class LogicsprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public LogicsprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            FadeParticle particle = new FadeParticle(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0, this.sprite, false);
            particle.m_107257_(12 + (int)(Math.random() * 8.0));
            return particle;
        }
    }

    public static class CreationsprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public CreationsprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            SparkleParticle particle = new SparkleParticle(pLevel, pX, pY, pZ, this.sprite, true);
            particle.m_107257_(10 + (int)(Math.random() * 4.0));
            particle.m_107253_(0.898039f, 0.890196f, 0.878431f);
            return particle;
        }
    }

    public static class GravitationsprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public GravitationsprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            AshParticle particle = new AshParticle(pLevel, pX, pY, pZ, 0.015, 0.015, 0.015, this.sprite);
            particle.m_107257_(20 + (int)(Math.random() * 10.0));
            particle.m_107253_(0.521568f, 0.494117f, 0.537254f);
            ((SprenParticle)particle).f_172258_ = 0.96f;
            return particle;
        }
    }

    public static class WindsprenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public WindsprenProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(@NotNull SimpleParticleType pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            UnlitParticle particle = new UnlitParticle(pLevel, pX, pY, pZ, 0.01, 0.01, 0.01, this.sprite, true);
            particle.m_107257_(12 + (int)(Math.random() * 8.0));
            ((SprenParticle)particle).f_107663_ *= 0.75f;
            return particle;
        }
    }

    public static class AuraParticle
    extends SparkleParticle {
        AuraParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet pSprites, boolean pSetSpriteFromAge) {
            super(pLevel, pX, pY, pZ, pSprites, pSetSpriteFromAge);
            this.f_107663_ *= 4.0f;
        }

        @Override
        public void m_5989_() {
            super.m_5989_();
            this.m_107271_(1.0f - (float)this.f_107224_ / (float)this.f_107225_);
        }

        @Override
        public int m_6355_(float pPartialTick) {
            return 240;
        }
    }

    public static class FadeParticle
    extends SprenParticle {
        FadeParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites, boolean pSetSpriteFromAge) {
            super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pSprites, pSetSpriteFromAge);
        }

        @Override
        public void m_5989_() {
            super.m_5989_();
            this.m_107271_(1.0f - (float)this.f_107224_ / (float)this.f_107225_);
        }
    }

    public static class ShrinkParticle
    extends SprenParticle {
        ShrinkParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites, boolean pSetSpriteFromAge) {
            super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pSprites, pSetSpriteFromAge);
        }

        public float m_5902_(float pScaleFactor) {
            return this.f_107663_ * Mth.m_14036_((float)(1.0f - (float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        }
    }

    public static class SparkleParticle
    extends SprenParticle {
        SparkleParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet pSprites, boolean pSetSpriteFromAge) {
            super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0, pSprites, pSetSpriteFromAge);
            this.f_107663_ *= 0.5f;
            this.f_172258_ = 0.96f;
            this.f_172259_ = true;
        }

        public int m_6355_(float pPartialTick) {
            float f = ((float)this.f_107224_ + pPartialTick) / (float)this.f_107225_;
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            int i = super.m_6355_(pPartialTick);
            int j = i & 0xFF;
            int k = i >> 16 & 0xFF;
            if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
                j = 240;
            }
            return j | k << 16;
        }

        public float m_5902_(float pScaleFactor) {
            return this.f_107663_ * Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        }
    }

    public static class UnlitAshParticle
    extends AshParticle {
        UnlitAshParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites) {
            super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pSprites);
        }

        public int m_6355_(float pPartialTick) {
            return 240;
        }
    }

    public static class AshParticle
    extends SprenParticle {
        AshParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites) {
            super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pSprites, false);
            this.f_107663_ *= 1.2f;
        }

        public float m_5902_(float pScaleFactor) {
            return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + pScaleFactor) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
        }
    }

    public static class UnlitParticle
    extends SprenParticle {
        UnlitParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites, boolean pSetSpriteFromAge) {
            super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pSprites, pSetSpriteFromAge);
        }

        public int m_6355_(float pPartialTick) {
            return 240;
        }
    }
}

