/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.recipe.FabrialBookCategory;
import us.amon.stormward.recipe.StormwardRecipeSerializers;
import us.amon.stormward.recipe.StormwardRecipeTypes;

public class FabrialRecipe
implements Recipe<CraftingContainer> {
    final String group;
    final FabrialBookCategory category;
    final NonNullList<ItemStack> results;
    final NonNullList<Ingredient> ingredients;

    public FabrialRecipe(String pGroup, FabrialBookCategory pCategory, NonNullList<ItemStack> pResults, NonNullList<Ingredient> pIngredients) {
        this.group = pGroup;
        this.category = pCategory;
        this.results = pResults;
        this.ingredients = pIngredients;
    }

    public String group() {
        return this.group;
    }

    public FabrialBookCategory category() {
        return this.category;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        StormlightStorageHelper.setFull(this.ingredients);
        return this.ingredients;
    }

    public boolean matches(@NotNull CraftingContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        for (int i = 1; i < this.ingredients.size(); ++i) {
            Ingredient extra = (Ingredient)this.ingredients.get(i);
            if (extra.m_43947_() || extra.test(pContainer.m_8020_(1)) || extra.test(pContainer.m_8020_(2))) continue;
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(pContainer.m_8020_(0));
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        ItemStack result = ((ItemStack)this.results.get(0)).m_41777_();
        StormlightStorageHelper.setFromContainerAverage((ICapabilityProvider)result, (Container)pContainer);
        return result;
    }

    @NotNull
    public ItemStack assembleSecondary(@NotNull CraftingContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        ItemStack result = this.results.size() > 1 ? ((ItemStack)this.results.get(1)).m_41777_() : ItemStack.f_41583_;
        StormlightStorageHelper.setFromContainerAverage((ICapabilityProvider)result, (Container)pContainer);
        return result;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@Nullable RegistryAccess pRegistryAccess) {
        ItemStack result = ((ItemStack)this.results.get(0)).m_41777_();
        StormlightStorageHelper.setFull((ICapabilityProvider)result);
        return result;
    }

    @NotNull
    public ItemStack getSecondaryResultItem(@Nullable RegistryAccess pRegistryAccess) {
        ItemStack result = this.results.size() > 1 ? ((ItemStack)this.results.get(1)).m_41777_() : ItemStack.f_41583_;
        StormlightStorageHelper.setFull((ICapabilityProvider)result);
        return result;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)StormwardRecipeSerializers.FABRIAL.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)StormwardRecipeTypes.FABRIAL.get();
    }

    public static class Serializer
    implements RecipeSerializer<FabrialRecipe> {
        private static final Codec<FabrialRecipe> CODEC = RecordCodecBuilder.create(recipeBuilder -> recipeBuilder.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(recipe -> recipe.group), (App)FabrialBookCategory.CODEC.fieldOf("category").orElse((Object)FabrialBookCategory.EQUIPMENT).forGetter(recipe -> recipe.category), (App)CraftingRecipeCodecs.f_290789_.listOf().fieldOf("results").flatXmap(results -> {
            Object[] aresult = (ItemStack[])results.stream().filter(result -> !result.m_41619_()).toArray(ItemStack[]::new);
            if (aresult.length == 0) {
                return DataResult.error(() -> "No results for fabrial recipe");
            }
            return aresult.length > 2 ? DataResult.error(() -> "Too many results for fabrial recipe") : DataResult.success((Object)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])aresult));
        }, DataResult::success).forGetter(recipe -> recipe.results), (App)Ingredient.f_290991_.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] aingredient = (Ingredient[])ingredients.stream().filter(ingredient -> !ingredient.m_43947_()).toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for fabrial recipe");
            }
            return aingredient.length > 3 ? DataResult.error(() -> "Too many ingredients for fabrial recipe") : DataResult.success((Object)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])aingredient));
        }, DataResult::success).forGetter(recipe -> recipe.ingredients)).apply((Applicative)recipeBuilder, FabrialRecipe::new));

        @NotNull
        public Codec<FabrialRecipe> m_292673_() {
            return CODEC;
        }

        @Nullable
        public FabrialRecipe fromNetwork(@NotNull FriendlyByteBuf pBuffer) {
            String group = pBuffer.m_130277_();
            FabrialBookCategory category = (FabrialBookCategory)pBuffer.m_130066_(FabrialBookCategory.class);
            int i = pBuffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            i = pBuffer.m_130242_();
            NonNullList results = NonNullList.m_122780_((int)i, (Object)ItemStack.f_41583_);
            for (int j = 0; j < results.size(); ++j) {
                results.set(j, (Object)pBuffer.m_130267_());
            }
            return new FabrialRecipe(group, category, (NonNullList<ItemStack>)results, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, @NotNull FabrialRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.group);
            pBuffer.m_130068_((Enum)pRecipe.category);
            pBuffer.m_130130_(pRecipe.ingredients.size());
            for (Ingredient ingredient : pRecipe.ingredients) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.m_130130_(pRecipe.results.size());
            for (ItemStack result : pRecipe.results) {
                pBuffer.m_130055_(result);
            }
        }
    }

    public static class Type
    implements RecipeType<FabrialRecipe> {
        public String toString() {
            return "fabrial";
        }
    }
}

