/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.recipe.FabrialBookCategory;
import us.amon.stormward.recipe.StormwardRecipeSerializers;

public class FabrialRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final List<Item> results = Lists.newArrayList();
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;

    public FabrialRecipeBuilder(RecipeCategory pCategory, ItemLike pResult, Ingredient pFabrial) {
        this.category = pCategory;
        this.results.add(pResult.m_5456_());
        this.ingredients.add(pFabrial);
    }

    public static FabrialRecipeBuilder fabrial(RecipeCategory pCategory, ItemLike pResult, Ingredient pFabrial) {
        return new FabrialRecipeBuilder(pCategory, pResult, pFabrial);
    }

    public static FabrialRecipeBuilder fabrial(RecipeCategory pCategory, ItemLike pResult, ItemLike pFabrial) {
        return new FabrialRecipeBuilder(pCategory, pResult, Ingredient.m_43929_((ItemLike[])new ItemLike[]{pFabrial}));
    }

    public FabrialRecipeBuilder requires(TagKey<Item> pTag) {
        return this.requires(Ingredient.m_204132_(pTag));
    }

    public FabrialRecipeBuilder requires(ItemLike pItem) {
        return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItem}));
    }

    public FabrialRecipeBuilder requires(ItemLike pItem, int pQuantity) {
        return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItem}), pQuantity);
    }

    public FabrialRecipeBuilder requires(Ingredient pIngredient) {
        return this.requires(pIngredient, 1);
    }

    public FabrialRecipeBuilder requires(Ingredient pIngredient, int pQuantity) {
        for (int i = 0; i < Math.min(pQuantity, 2); ++i) {
            this.ingredients.add(pIngredient);
        }
        return this;
    }

    public FabrialRecipeBuilder secondaryResult(ItemLike pResult) {
        this.results.add(pResult.m_5456_());
        return this;
    }

    @NotNull
    public RecipeBuilder m_126132_(@NotNull String pName, @NotNull Criterion<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    @NotNull
    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    @NotNull
    public Item m_142372_() {
        return this.results.get(0);
    }

    public void m_126140_(@NotNull RecipeOutput pRecipeOutput, @NotNull ResourceLocation pId) {
        this.ensureValid(pId);
        Advancement.Builder builder = pRecipeOutput.m_293552_().m_138383_("has_the_recipe", RecipeUnlockedTrigger.m_63728_((ResourceLocation)pId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pId)).m_138360_(AdvancementRequirements.Strategy.f_291456_);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).m_138383_(arg_0, arg_1));
        pRecipeOutput.m_292927_((FinishedRecipe)new Result(pId, this.results, this.group == null ? "" : this.group, FabrialRecipeBuilder.determineBookCategory(this.category), this.ingredients, builder.m_138403_(pId.m_246208_("recipes/" + this.category.m_247710_() + "/"))));
    }

    protected static FabrialBookCategory determineBookCategory(RecipeCategory pCategory) {
        return switch (pCategory) {
            case RecipeCategory.BUILDING_BLOCKS, RecipeCategory.DECORATIONS, RecipeCategory.REDSTONE -> FabrialBookCategory.BLOCKS;
            default -> FabrialBookCategory.EQUIPMENT;
        };
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pId);
        }
        if (this.results.size() > 2) {
            throw new IllegalStateException("Too many results for recipe " + pId);
        }
        if (this.ingredients.size() > 3) {
            throw new IllegalStateException("Too many ingredients for recipe " + pId);
        }
    }

    protected static class Result
    implements FinishedRecipe {
        private final FabrialBookCategory category;
        private final ResourceLocation id;
        private final List<Item> results;
        private final String group;
        private final List<Ingredient> ingredients;
        private final AdvancementHolder advancement;

        public Result(ResourceLocation pId, List<Item> pResults, String pGroup, FabrialBookCategory pCategory, List<Ingredient> pIngredients, AdvancementHolder pAdvancement) {
            this.id = pId;
            this.results = pResults;
            this.group = pGroup;
            this.category = pCategory;
            this.ingredients = pIngredients;
            this.advancement = pAdvancement;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.addProperty("category", this.category.m_7912_());
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            JsonArray ingredientArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                ingredientArray.add(ingredient.m_43942_(false));
            }
            pJson.add("ingredients", (JsonElement)ingredientArray);
            JsonArray resultArray = new JsonArray();
            for (Item result : this.results) {
                JsonObject resultObject = new JsonObject();
                resultObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)result).toString());
                resultArray.add((JsonElement)resultObject);
            }
            pJson.add("results", (JsonElement)resultArray);
        }

        @NotNull
        public RecipeSerializer<?> m_126169_() {
            return (RecipeSerializer)StormwardRecipeSerializers.FABRIAL.get();
        }

        @NotNull
        public ResourceLocation m_126168_() {
            return this.id;
        }

        public AdvancementHolder m_126373_() {
            return this.advancement;
        }
    }
}

