/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import us.amon.stormward.entity.villager.SphereMerchantOffer;
import us.amon.stormward.menu.SphereMerchantMenu;

public class SphereMerchantScreen
extends AbstractContainerScreen<SphereMerchantMenu> {
    private static final ResourceLocation OUT_OF_STOCK_SPRITE = new ResourceLocation("container/villager/out_of_stock");
    private static final ResourceLocation EXPERIENCE_BAR_BACKGROUND_SPRITE = new ResourceLocation("container/villager/experience_bar_background");
    private static final ResourceLocation EXPERIENCE_BAR_CURRENT_SPRITE = new ResourceLocation("container/villager/experience_bar_current");
    private static final ResourceLocation EXPERIENCE_BAR_RESULT_SPRITE = new ResourceLocation("container/villager/experience_bar_result");
    private static final ResourceLocation SCROLLER_SPRITE = new ResourceLocation("container/villager/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = new ResourceLocation("container/villager/scroller_disabled");
    private static final ResourceLocation TRADE_ARROW_OUT_OF_STOCK_SPRITE = new ResourceLocation("container/villager/trade_arrow_out_of_stock");
    private static final ResourceLocation TRADE_ARROW_SPRITE = new ResourceLocation("container/villager/trade_arrow");
    private static final ResourceLocation DISCOUNT_STRIKETHROUGH_SPRITE = new ResourceLocation("container/villager/discount_strikethrough");
    private static final ResourceLocation SPHERE_STRIKETHROUGH_SPRITE = new ResourceLocation("stormward", "container/sphere_merchant/sphere_strikethrough");
    private static final ResourceLocation SPHERE_EMPTY_SPRITE = new ResourceLocation("stormward", "container/sphere_merchant/sphere_empty");
    private static final ResourceLocation VILLAGER_LOCATION = new ResourceLocation("textures/gui/container/villager.png");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int MERCHANT_MENU_PART_X = 99;
    private static final int PROGRESS_BAR_X = 136;
    private static final int PROGRESS_BAR_Y = 16;
    private static final int SELL_ITEM_1_X = 5;
    private static final int SELL_ITEM_2_X = 35;
    private static final int BUY_ITEM_X = 68;
    private static final int LABEL_Y = 6;
    private static final int NUMBER_OF_OFFER_BUTTONS = 7;
    private static final int TRADE_BUTTON_X = 5;
    private static final int TRADE_BUTTON_HEIGHT = 20;
    private static final int TRADE_BUTTON_WIDTH = 88;
    private static final int SCROLLER_HEIGHT = 27;
    private static final int SCROLLER_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 139;
    private static final int SCROLL_BAR_TOP_POS_Y = 18;
    private static final int SCROLL_BAR_START_X = 94;
    private static final Component TRADES_LABEL = Component.m_237115_((String)"merchant.trades");
    private static final Component DEPRECATED_TOOLTIP = Component.m_237115_((String)"merchant.deprecated");
    private int shopItem;
    private final TradeOfferButton[] tradeOfferButtons = new TradeOfferButton[7];
    int scrollOff;
    private boolean isDragging;

    public SphereMerchantScreen(SphereMerchantMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 276;
        this.f_97730_ = 107;
    }

    private void postButtonClick() {
        ((SphereMerchantMenu)this.f_97732_).m_40063_(this.shopItem);
        ((SphereMerchantMenu)this.f_97732_).m_40072_(this.shopItem);
        this.f_96541_.m_91403_().m_295327_((Packet)new ServerboundSelectTradePacket(this.shopItem));
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        int k = j + 16 + 2;
        for (int l = 0; l < 7; ++l) {
            this.tradeOfferButtons[l] = (TradeOfferButton)this.m_142416_((GuiEventListener)new TradeOfferButton(i + 5, k, l, p_99174_ -> {
                if (p_99174_ instanceof TradeOfferButton) {
                    this.shopItem = ((TradeOfferButton)p_99174_).getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            k += 20;
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int i = ((SphereMerchantMenu)this.f_97732_).m_40071_();
        if (i > 0 && i <= 5 && ((SphereMerchantMenu)this.f_97732_).m_40076_()) {
            MutableComponent component = Component.m_237110_((String)"merchant.title", (Object[])new Object[]{this.f_96539_, Component.m_237115_((String)("merchant.level." + i))});
            int j = this.f_96547_.m_92852_((FormattedText)component);
            int k = 49 + this.f_97726_ / 2 - j / 2;
            pGuiGraphics.m_280614_(this.f_96547_, (Component)component, k, 6, 0x404040, false);
        } else {
            pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, 49 + this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 6, 0x404040, false);
        }
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
        int l = this.f_96547_.m_92852_((FormattedText)TRADES_LABEL);
        pGuiGraphics.m_280614_(this.f_96547_, TRADES_LABEL, 5 - l / 2 + 48, 6, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280398_(VILLAGER_LOCATION, i, j, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        MerchantOffers merchantoffers = ((SphereMerchantMenu)this.f_97732_).m_40075_();
        if (!merchantoffers.isEmpty()) {
            int k = this.shopItem;
            if (k < 0 || k >= merchantoffers.size()) {
                return;
            }
            MerchantOffer merchantoffer = (MerchantOffer)merchantoffers.get(k);
            if (merchantoffer.m_45380_()) {
                pGuiGraphics.m_295520_(OUT_OF_STOCK_SPRITE, this.f_97735_ + 83 + 99, this.f_97736_ + 35, 0, 28, 21);
            }
        }
    }

    private void renderProgressBar(GuiGraphics pGuiGraphics, int pPosX, int pPosY, MerchantOffer pMerchantOffer) {
        int i = ((SphereMerchantMenu)this.f_97732_).m_40071_();
        int j = ((SphereMerchantMenu)this.f_97732_).m_40065_();
        if (i < 5) {
            pGuiGraphics.m_295520_(EXPERIENCE_BAR_BACKGROUND_SPRITE, pPosX + 136, pPosY + 16, 0, 102, 5);
            int k = VillagerData.m_35572_((int)i);
            if (j >= k && VillagerData.m_35582_((int)i)) {
                int l = 102;
                float f = 102.0f / (float)(VillagerData.m_35577_((int)i) - k);
                int i1 = Math.min(Mth.m_14143_((float)(f * (float)(j - k))), 102);
                pGuiGraphics.m_293068_(EXPERIENCE_BAR_CURRENT_SPRITE, 102, 5, 0, 0, pPosX + 136, pPosY + 16, 0, i1, 5);
                int j1 = ((SphereMerchantMenu)this.f_97732_).m_40068_();
                if (j1 > 0) {
                    int k1 = Math.min(Mth.m_14143_((float)((float)j1 * f)), 102 - i1);
                    pGuiGraphics.m_293068_(EXPERIENCE_BAR_RESULT_SPRITE, 102, 5, i1, 0, pPosX + 136 + i1, pPosY + 16, 0, k1, 5);
                }
            }
        }
    }

    private void renderScroller(GuiGraphics pGuiGraphics, int pPosX, int pPosY, MerchantOffers pMerchantOffers) {
        int i = pMerchantOffers.size() + 1 - 7;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int l = 113;
            int i1 = Math.min(113, this.scrollOff * k);
            if (this.scrollOff == i - 1) {
                i1 = 113;
            }
            pGuiGraphics.m_295520_(SCROLLER_SPRITE, pPosX + 94, pPosY + 18 + i1, 0, 6, 27);
        } else {
            pGuiGraphics.m_295520_(SCROLLER_DISABLED_SPRITE, pPosX + 94, pPosY + 18, 0, 6, 27);
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        MerchantOffers merchantoffers = ((SphereMerchantMenu)this.f_97732_).m_40075_();
        if (!merchantoffers.isEmpty()) {
            int i = (this.f_96543_ - this.f_97726_) / 2;
            int j = (this.f_96544_ - this.f_97727_) / 2;
            int k = j + 16 + 1;
            int l = i + 5 + 5;
            this.renderScroller(pGuiGraphics, i, j, merchantoffers);
            int i1 = 0;
            for (MerchantOffer offer : merchantoffers) {
                if (!this.canScroll(merchantoffers.size()) || i1 >= this.scrollOff && i1 < 7 + this.scrollOff) {
                    ItemStack baseCostA = offer.m_45352_();
                    ItemStack baseCostB = ItemStack.f_41583_;
                    if (offer instanceof SphereMerchantOffer) {
                        SphereMerchantOffer sphereOffer = (SphereMerchantOffer)offer;
                        baseCostB = sphereOffer.getBaseCostB();
                    }
                    ItemStack costA = offer.m_45358_();
                    ItemStack costB = offer.m_45364_();
                    ItemStack result = offer.m_45368_();
                    pGuiGraphics.m_280168_().m_85836_();
                    pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
                    int j1 = k + 2;
                    this.renderAndDecorateCost(pGuiGraphics, costA, baseCostA, l, j1);
                    this.renderAndDecorateCost(pGuiGraphics, costB, baseCostB, i + 5 + 28, j1);
                    this.renderButtonArrows(pGuiGraphics, offer, i, j1);
                    pGuiGraphics.m_280203_(result, i + 5 + 68, j1);
                    pGuiGraphics.m_280370_(this.f_96547_, result, i + 5 + 68, j1);
                    pGuiGraphics.m_280168_().m_85849_();
                    k += 20;
                    ++i1;
                    continue;
                }
                ++i1;
            }
            int k1 = this.shopItem;
            MerchantOffer merchantoffer1 = (MerchantOffer)merchantoffers.get(k1);
            if (((SphereMerchantMenu)this.f_97732_).m_40076_()) {
                this.renderProgressBar(pGuiGraphics, i, j, merchantoffer1);
            }
            if (merchantoffer1.m_45380_() && this.m_6774_(186, 35, 22, 21, pMouseX, pMouseY) && ((SphereMerchantMenu)this.f_97732_).m_40074_()) {
                pGuiGraphics.m_280557_(this.f_96547_, DEPRECATED_TOOLTIP, pMouseX, pMouseY);
            }
            for (TradeOfferButton merchantscreen$tradeofferbutton : this.tradeOfferButtons) {
                if (merchantscreen$tradeofferbutton.m_198029_()) {
                    merchantscreen$tradeofferbutton.renderToolTip(pGuiGraphics, pMouseX, pMouseY);
                }
                merchantscreen$tradeofferbutton.f_93624_ = merchantscreen$tradeofferbutton.index < ((SphereMerchantMenu)this.f_97732_).m_40075_().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderButtonArrows(GuiGraphics pGuiGraphics, MerchantOffer pMerchantOffers, int pPosX, int pPosY) {
        RenderSystem.enableBlend();
        if (pMerchantOffers.m_45380_()) {
            pGuiGraphics.m_295520_(TRADE_ARROW_OUT_OF_STOCK_SPRITE, pPosX + 5 + 32 + 20, pPosY + 3, 0, 10, 9);
        } else {
            pGuiGraphics.m_295520_(TRADE_ARROW_SPRITE, pPosX + 5 + 32 + 20, pPosY + 3, 0, 10, 9);
        }
    }

    private void renderAndDecorateCost(GuiGraphics pGuiGraphics, ItemStack pRealCost, ItemStack pBaseCost, int pX, int pY) {
        if (pBaseCost.m_150930_(pRealCost.m_41720_())) {
            if (!pRealCost.m_41619_()) {
                pGuiGraphics.m_280203_(pRealCost, pX, pY);
                if (pBaseCost.m_41613_() == pRealCost.m_41613_()) {
                    pGuiGraphics.m_280370_(this.f_96547_, pRealCost, pX, pY);
                } else {
                    this.renderAndDecorateVanillaCost(pGuiGraphics, pRealCost, pBaseCost, pX, pY);
                }
            }
        } else if (!pBaseCost.m_41619_() && pRealCost.m_41619_()) {
            this.renderAndDecorateBaseCost(pGuiGraphics, pBaseCost, pX, pY);
        } else {
            this.renderAndDecorateBaseCost(pGuiGraphics, pBaseCost, pX - 3, pY - 2);
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            pGuiGraphics.m_280203_(pRealCost, pX + 3, pY + 2);
            pGuiGraphics.m_280370_(this.f_96547_, pRealCost, pX + 3, pY + 2);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }

    private void renderAndDecorateBaseCost(GuiGraphics pGuiGraphics, ItemStack pBaseCost, int pX, int pY) {
        if (pBaseCost.m_41619_()) {
            pGuiGraphics.m_295520_(SPHERE_EMPTY_SPRITE, pX, pY, 0, 16, 16);
        } else {
            pGuiGraphics.m_280246_(0.75f, 0.75f, 0.75f, 1.0f);
            pGuiGraphics.m_280203_(pBaseCost, pX, pY);
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            pGuiGraphics.m_280370_(this.f_96547_, pBaseCost, pX, pY);
        }
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        pGuiGraphics.m_295520_(SPHERE_STRIKETHROUGH_SPRITE, pX, pY, 0, 16, 16);
        pGuiGraphics.m_280168_().m_85849_();
    }

    private void renderAndDecorateVanillaCost(GuiGraphics pGuiGraphics, ItemStack pRealCost, ItemStack pBaseCost, int pX, int pY) {
        pGuiGraphics.m_280302_(this.f_96547_, pBaseCost, pX, pY, pBaseCost.m_41613_() == 1 ? "1" : null);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        String count = pRealCost.m_41613_() == 1 ? "1" : String.valueOf(pRealCost.m_41613_());
        this.f_96547_.m_272078_(count, (float)(pX + 14) + 19.0f - 2.0f - (float)this.f_96547_.m_92895_(count), (float)pY + 6.0f + 3.0f, 0xFFFFFF, true, pGuiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)pGuiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0, false);
        pGuiGraphics.m_280168_().m_85849_();
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        pGuiGraphics.m_295520_(DISCOUNT_STRIKETHROUGH_SPRITE, pX + 7, pY + 12, 0, 9, 2);
        pGuiGraphics.m_280168_().m_85849_();
    }

    private boolean canScroll(int pNumOffers) {
        return pNumOffers > 7;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        int i = ((SphereMerchantMenu)this.f_97732_).m_40075_().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOff = Mth.m_14045_((int)((int)((double)this.scrollOff - pScrollY)), (int)0, (int)j);
        }
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int i = ((SphereMerchantMenu)this.f_97732_).m_40075_().size();
        if (this.isDragging) {
            int j = this.f_97736_ + 18;
            int k = j + 139;
            int l = i - 7;
            float f = ((float)pMouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrollOff = Mth.m_14045_((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.isDragging = false;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (this.canScroll(((SphereMerchantMenu)this.f_97732_).m_40075_().size()) && pMouseX > (double)(i + 94) && pMouseX < (double)(i + 94 + 6) && pMouseY > (double)(j + 18) && pMouseY <= (double)(j + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    @OnlyIn(value=Dist.CLIENT)
    class TradeOfferButton
    extends Button {
        final int index;

        public TradeOfferButton(int pX, int pY, int pIndex, Button.OnPress pOnPress) {
            super(pX, pY, 88, 20, CommonComponents.f_237098_, pOnPress, f_252438_);
            this.index = pIndex;
            this.f_93624_ = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void renderToolTip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
            if (this.f_93622_ && ((SphereMerchantMenu)SphereMerchantScreen.this.f_97732_).m_40075_().size() > this.index + SphereMerchantScreen.this.scrollOff) {
                if (pMouseX < this.m_252754_() + 23 && pMouseX > this.m_252754_() + 2) {
                    ItemStack itemstack = ((MerchantOffer)((SphereMerchantMenu)SphereMerchantScreen.this.f_97732_).m_40075_().get(this.index + SphereMerchantScreen.this.scrollOff)).m_45358_();
                    pGuiGraphics.m_280153_(SphereMerchantScreen.this.f_96547_, itemstack, pMouseX, pMouseY);
                } else if (pMouseX < this.m_252754_() + 47 && pMouseX > this.m_252754_() + 25) {
                    ItemStack itemstack2 = ((MerchantOffer)((SphereMerchantMenu)SphereMerchantScreen.this.f_97732_).m_40075_().get(this.index + SphereMerchantScreen.this.scrollOff)).m_45364_();
                    if (!itemstack2.m_41619_()) {
                        pGuiGraphics.m_280153_(SphereMerchantScreen.this.f_96547_, itemstack2, pMouseX, pMouseY);
                    }
                } else if (pMouseX < this.m_252754_() + 87 && pMouseX > this.m_252754_() + 65) {
                    ItemStack itemstack1 = ((MerchantOffer)((SphereMerchantMenu)SphereMerchantScreen.this.f_97732_).m_40075_().get(this.index + SphereMerchantScreen.this.scrollOff)).m_45368_();
                    pGuiGraphics.m_280153_(SphereMerchantScreen.this.f_96547_, itemstack1, pMouseX, pMouseY);
                }
            }
        }
    }
}

