/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.part.IndexedPart;

public class BookmarkButton
extends Button {
    private static final ResourceLocation[] SPRITE = new ResourceLocation[]{new ResourceLocation("stormward", "widget/book/red_bookmark"), new ResourceLocation("stormward", "widget/book/purple_bookmark"), new ResourceLocation("stormward", "widget/book/blue_bookmark"), new ResourceLocation("stormward", "widget/book/green_bookmark"), new ResourceLocation("stormward", "widget/book/orange_bookmark"), new ResourceLocation("stormward", "widget/book/pink_bookmark")};
    private static final ResourceLocation[] FRONT_SPRITE = new ResourceLocation[]{new ResourceLocation("stormward", "widget/book/red_bookmark_front"), new ResourceLocation("stormward", "widget/book/purple_bookmark_front"), new ResourceLocation("stormward", "widget/book/blue_bookmark_front"), new ResourceLocation("stormward", "widget/book/green_bookmark_front"), new ResourceLocation("stormward", "widget/book/orange_bookmark_front"), new ResourceLocation("stormward", "widget/book/pink_bookmark_front")};
    private static final int MOVE_TIME = 4;
    public static final int WIDTH = 20;
    public static final int HEIGHT = 24;
    public static final int FRONT_HEIGHT = 196;
    private final Font font;
    private final IndexedPart part;
    private int startX;
    private int endX;
    private int moveTime;
    private boolean front;
    private int z;

    public BookmarkButton(Book pBook, int pPartNum, int pX, int pY) {
        super(pX, pY, 20, 24, CommonComponents.f_237098_, button -> pBook.setPart(pPartNum, true), f_252438_);
        this.font = pBook.getFont();
        this.part = (IndexedPart)pBook.getPart(pPartNum);
    }

    public void tick() {
        if (++this.moveTime < 4) {
            this.m_252865_(Mth.m_295919_((float)((float)this.moveTime / 4.0f), (int)this.startX, (int)this.endX));
        } else {
            this.endMove();
        }
        this.part.getIcon().tick();
    }

    public void moveTo(int pX) {
        this.startX = this.m_252754_();
        this.endX = pX;
        this.moveTime = 0;
    }

    public void endMove() {
        this.m_252865_(this.endX);
        this.startX = this.endX;
        this.moveTime = 4;
    }

    public void setFront(boolean pFront) {
        this.front = pFront;
    }

    public void setZ(int pZ) {
        this.z = pZ;
    }

    public void m_87963_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280168_().m_85836_();
        int prevX = Mth.m_295919_((float)((float)(this.moveTime - 1) / 4.0f), (int)this.startX, (int)this.endX);
        pGuiGraphics.m_280168_().m_252880_(Mth.m_14179_((float)pPartialTick, (float)(this.m_252754_() - prevX), (float)0.0f), 0.0f, (float)this.z);
        if (this.front) {
            pGuiGraphics.m_292816_(FRONT_SPRITE[this.part.getColor()], this.m_252754_(), this.m_252907_() - 196 + 24, 20, 196);
        } else {
            pGuiGraphics.m_292816_(SPRITE[this.part.getColor()], this.m_252754_(), this.m_252907_(), 20, 24);
        }
        this.part.getIcon().render(pGuiGraphics, this.m_252754_() + 2, this.m_252907_() + 2);
        pGuiGraphics.m_280168_().m_85849_();
        if (this.m_274382_() && this.m_142518_()) {
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
            pGuiGraphics.m_280557_(this.font, this.part.getTitle(), pMouseX, pMouseY);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }

    public void m_7435_(SoundManager pHandler) {
        pHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
    }
}

