/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.chapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.chapter.Chapter;
import us.amon.stormward.screen.book.element.Element;

public class ElementChapter
extends Chapter {
    private final List<List<Element>> pages;
    private List<Element> leftPage;
    private List<Element> rightPage;

    public ElementChapter(Book pBook, Component pTitle, JsonObject pChapterJson) {
        super(pBook, pTitle);
        ArrayList elements = new ArrayList();
        this.getElementArray(pChapterJson).forEach(element -> elements.addAll(Element.getElementsFromJson(this.book, element)));
        this.pages = new ArrayList<List<Element>>();
        ArrayList<Element> page = new ArrayList<Element>();
        int height = 28;
        boolean left = true;
        for (int i = 0; i < elements.size(); ++i) {
            Element element2 = (Element)elements.get(i);
            int chainHeight = element2.getHeight();
            for (int j = i; j < elements.size() - 1 && ((Element)elements.get(j)).isLinked(); ++j) {
                chainHeight += ((Element)elements.get(j)).getMargin() + ((Element)elements.get(j + 1)).getHeight();
            }
            if (height + chainHeight > 154) {
                this.pages.add(page);
                page = new ArrayList();
                left = !left;
                height = 28;
            }
            if (height <= 28 && element2.isEmpty()) continue;
            element2.setX(left ? 17 : 141);
            element2.setY(height);
            page.add(element2);
            height += element2.getHeightWithMargin();
        }
        if (!page.isEmpty()) {
            this.pages.add(page);
        }
        this.updateSpread();
    }

    private Iterable<JsonElement> getElementArray(JsonObject pChapterJson) {
        JsonElement elementsJson;
        JsonElement jsonElement = elementsJson = pChapterJson.has("element") ? pChapterJson.get("element") : pChapterJson.get("elements");
        if (elementsJson.isJsonArray()) {
            return elementsJson.getAsJsonArray();
        }
        return List.of(elementsJson);
    }

    @Override
    public int getNumSpreads() {
        return Math.max(1, Mth.m_184652_((int)this.pages.size(), (int)2));
    }

    @Override
    protected void updateSpread() {
        this.leftPage = this.spread * 2 < this.pages.size() ? this.pages.get(this.spread * 2) : List.of();
        this.rightPage = this.spread * 2 + 1 < this.pages.size() ? this.pages.get(this.spread * 2 + 1) : List.of();
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderPage(pGuiGraphics, pMouseX, pMouseY, pPartialTick, this.leftPage);
        this.renderPage(pGuiGraphics, pMouseX, pMouseY, pPartialTick, this.rightPage);
    }

    private void renderPage(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, List<Element> pPage) {
        for (Element element : pPage) {
            element.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    @Override
    public void tick() {
        this.tickPage(this.leftPage);
        this.tickPage(this.rightPage);
    }

    private void tickPage(List<Element> pPage) {
        for (Element element : pPage) {
            element.tick();
        }
    }

    @Override
    public boolean mouseClicked(double pX, double pY, int pButton) {
        return this.clickPage(pX, pY, pButton, pX < 137.0 ? this.leftPage : this.rightPage);
    }

    private boolean clickPage(double pX, double pY, int pButton, List<Element> pPage) {
        for (Element element : pPage) {
            if (!(pY >= (double)element.getY()) || !(pY < (double)(element.getY() + element.getHeight()))) continue;
            return element.mouseClicked(pX, pY, pButton);
        }
        return false;
    }

    @Override
    protected void addWidgets() {
        this.addWidgetsForPage(this.leftPage);
        this.addWidgetsForPage(this.rightPage);
    }

    private void addWidgetsForPage(List<Element> pPage) {
        for (Element element : pPage) {
            element.addWidgets();
        }
    }

    @Override
    protected void removeWidgets() {
        this.removeWidgetsForPage(this.leftPage);
        this.removeWidgetsForPage(this.rightPage);
    }

    private void removeWidgetsForPage(List<Element> pPage) {
        for (Element element : pPage) {
            element.removeWidgets();
        }
    }
}

