/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.chapter;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.chapter.Chapter;
import us.amon.stormward.screen.book.chapter.IndexButton;
import us.amon.stormward.screen.book.part.IndexedPart;

public class IndexChapter
extends Chapter {
    private static final int ROWS = 5;
    private static final int COLUMNS = 4;
    public final IndexedPart part;
    public List<IndexButton> buttons;

    public IndexChapter(Book pBook, IndexedPart pPart) {
        super(pBook, pPart.getTitle());
        this.part = pPart;
        this.buttons = new ArrayList<IndexButton>();
    }

    @Override
    public int getNumSpreads() {
        int firstSpreadCount = 35;
        return 1 + Math.max(0, Mth.m_184652_((int)(this.part.getChapters().size() - firstSpreadCount), (int)40));
    }

    @Override
    public void tick() {
        for (IndexButton button : this.buttons) {
            button.tick();
        }
    }

    @Override
    protected void addWidgets() {
        this.addWidgetsForPage(true);
        this.addWidgetsForPage(false);
    }

    private void addWidgetsForPage(boolean pIsLeft) {
        int xOffset = pIsLeft ? 17 : 141;
        int yOffset = 28;
        int width = 115;
        int columns = 4;
        if (this.spread == 0 && !pIsLeft) {
            xOffset += 20;
            width -= 20;
            --columns;
        }
        int spareWidth = width - 20 * columns;
        int spareHeight = 154 - yOffset - 100;
        int margin = Math.min(spareWidth / (columns - 1), spareHeight / 4);
        xOffset += (spareWidth - margin * (columns - 1)) / 2;
        yOffset += (spareHeight - margin * 4) / 2;
        List<ResourceLocation> chapters = this.part.getChapters();
        int start = 20 * (this.spread * 2 + (pIsLeft ? 0 : 1));
        if (this.spread > 0) {
            start -= 5;
        }
        int end = Math.min(start + 5 * columns, chapters.size());
        int i = 0;
        while (start + i < end) {
            int x = xOffset + i % columns * (20 + margin);
            int y = yOffset + i / columns * (20 + margin);
            this.buttons.add(this.book.addWidget(new IndexButton(this.book, chapters.get(start + i), x, y)));
            ++i;
        }
    }

    @Override
    protected void removeWidgets() {
        for (IndexButton button : this.buttons) {
            this.book.removeWidget((GuiEventListener)button);
        }
        this.buttons.clear();
    }
}

