/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.PageBreakElement;
import us.amon.stormward.screen.book.element.SpritePageElement;
import us.amon.stormward.screen.book.element.TextElement;
import us.amon.stormward.screen.book.element.animation.AnimationPageElement;
import us.amon.stormward.screen.book.element.obtaining.BlockLootPageElement;
import us.amon.stormward.screen.book.element.obtaining.CookingRecipePageElement;
import us.amon.stormward.screen.book.element.obtaining.CraftingRecipePageElement;
import us.amon.stormward.screen.book.element.obtaining.EntityLootPageElement;
import us.amon.stormward.screen.book.element.obtaining.FabrialRecipePageElement;
import us.amon.stormward.screen.book.element.obtaining.NetheriteUpgradePageElement;
import us.amon.stormward.screen.book.element.obtaining.SoulcasterRecipePageElement;
import us.amon.stormward.screen.book.element.obtaining.StructureLootPageElement;
import us.amon.stormward.screen.book.element.resources.ResourcesPageElement;

public class Element {
    protected final Book book;
    private int x;
    private int y;

    public Element(Book pBook) {
        this.book = pBook;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int pX) {
        this.x = pX;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int pY) {
        this.y = pY;
    }

    public boolean isLinked() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public void tick() {
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public int getWidth() {
        return 115;
    }

    public int getHeight() {
        return 0;
    }

    public int getHeightWithMargin() {
        return this.getHeight() + this.getMargin();
    }

    public int getMargin() {
        return 8;
    }

    public boolean mouseClicked(double pX, double pY, int pButton) {
        return false;
    }

    public void addWidgets() {
    }

    public void removeWidgets() {
    }

    public static List<? extends Element> getElementsFromJson(Book pBook, JsonElement pJson) {
        if (pJson.isJsonObject()) {
            JsonObject elementJson = pJson.getAsJsonObject();
            return switch (elementJson.get("type").getAsString()) {
                case "page_break" -> List.of(new PageBreakElement(pBook));
                case "sprite" -> List.of(new SpritePageElement(pBook, elementJson));
                case "animation" -> List.of(new AnimationPageElement(pBook, elementJson));
                case "entity_loot" -> List.of(new EntityLootPageElement(pBook, elementJson));
                case "block_loot" -> List.of(new BlockLootPageElement(pBook, elementJson));
                case "structure_loot" -> List.of(new StructureLootPageElement(pBook, elementJson));
                case "crafting_recipe" -> List.of(new CraftingRecipePageElement(pBook, elementJson));
                case "cooking_recipe" -> List.of(new CookingRecipePageElement(pBook, elementJson));
                case "fabrial_recipe" -> List.of(new FabrialRecipePageElement(pBook, elementJson));
                case "soulcaster_recipe" -> List.of(new SoulcasterRecipePageElement(pBook, elementJson));
                case "netherite_upgrade" -> List.of(new NetheriteUpgradePageElement(pBook, elementJson));
                case "items", "blocks", "entities", "structures" -> List.of(new ResourcesPageElement(pBook, elementJson));
                default -> TextElement.fromJsonObject(pBook, elementJson);
            };
        }
        return TextElement.fromString(pBook, pJson.getAsString());
    }
}

