/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.animation;

import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.animation.BlockActor;
import us.amon.stormward.screen.book.element.animation.EntityActor;
import us.amon.stormward.screen.book.element.animation.ItemActor;
import us.amon.stormward.screen.book.element.animation.ParticleEmitterActor;
import us.amon.stormward.screen.book.element.animation.SpriteActor;

public abstract class AnimationActor {
    protected final double initialX;
    protected final double initialY;
    protected final int width;
    protected final int height;
    protected final boolean initialVisible;
    protected double xo;
    protected double yo;
    protected double x;
    protected double y;
    protected boolean visible;

    public AnimationActor(JsonObject pActorJson) {
        this.initialX = pActorJson.has("x") ? pActorJson.get("x").getAsDouble() : 0.0;
        this.initialY = pActorJson.has("y") ? pActorJson.get("y").getAsDouble() : 0.0;
        this.width = pActorJson.has("width") ? pActorJson.get("width").getAsInt() : 16;
        this.height = pActorJson.has("height") ? pActorJson.get("height").getAsInt() : 16;
        this.initialVisible = !pActorJson.has("visible") || pActorJson.get("visible").getAsBoolean();
    }

    public void tick() {
    }

    public abstract void render(GuiGraphics var1, int var2, int var3, float var4);

    public void reset() {
        this.setX(this.initialX);
        this.setY(this.initialY);
        this.visible = this.initialVisible;
    }

    public void setXSmooth(double pX) {
        this.xo = this.x;
        this.x = pX;
    }

    public void setX(double pX) {
        this.xo = pX;
        this.x = pX;
    }

    public double getX(float pPartialTick) {
        return Mth.m_14139_((double)pPartialTick, (double)this.xo, (double)this.x);
    }

    public void setYSmooth(double pY) {
        this.yo = this.y;
        this.y = pY;
    }

    public void setY(double pY) {
        this.yo = pY;
        this.y = pY;
    }

    public double getY(float pPartialTick) {
        return Mth.m_14139_((double)pPartialTick, (double)this.yo, (double)this.y);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public static AnimationActor getActorFromJson(Book pBook, JsonObject pActorJson) {
        return switch (pActorJson.get("type").getAsString()) {
            case "block" -> new BlockActor(pBook, pActorJson);
            case "item" -> new ItemActor(pBook, pActorJson);
            case "entity" -> new EntityActor(pBook, pActorJson);
            case "particle" -> new ParticleEmitterActor(pActorJson);
            default -> new SpriteActor(pActorJson);
        };
    }
}

