/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.animation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.PageElement;
import us.amon.stormward.screen.book.element.animation.AnimationAction;
import us.amon.stormward.screen.book.element.animation.AnimationActor;
import us.amon.stormward.screen.book.element.animation.AnimationStep;

public class AnimationPageElement
extends PageElement {
    private final Map<String, AnimationActor> actors = new HashMap<String, AnimationActor>();
    private final List<AnimationStep> steps;
    private int stepIndex;
    private AnimationStep step;
    private int stepTime;
    private int stepDuration;

    public AnimationPageElement(Book pBook, JsonObject pElementJson) {
        super(pBook, pElementJson);
        for (Map.Entry entry : pElementJson.getAsJsonObject("actors").entrySet()) {
            AnimationActor actor = AnimationActor.getActorFromJson(pBook, ((JsonElement)entry.getValue()).getAsJsonObject());
            actor.reset();
            this.actors.put((String)entry.getKey(), actor);
        }
        this.steps = new ArrayList<AnimationStep>();
        JsonElement stepsJson = pElementJson.get("steps");
        if (stepsJson.isJsonArray()) {
            for (JsonElement element : stepsJson.getAsJsonArray()) {
                this.steps.add(new AnimationStep(element));
            }
        } else {
            this.steps.add(new AnimationStep(stepsJson));
        }
        this.setStep(0);
    }

    @Override
    public void tick() {
        ++this.stepTime;
        if (this.stepTime > this.stepDuration) {
            this.setStep(++this.stepIndex);
        }
        for (AnimationAction action : this.step.getActions()) {
            action.tickAction(this.actors.get(action.getActor()), this.stepTime);
        }
        for (AnimationActor actor : this.actors.values()) {
            actor.tick();
        }
    }

    protected void setStep(int pStep) {
        if (this.step != null) {
            for (AnimationAction action : this.step.getActions()) {
                action.endAction(this.actors.get(action.getActor()));
            }
        }
        this.stepIndex = pStep % this.steps.size();
        this.step = this.steps.get(this.stepIndex);
        this.stepTime = 0;
        this.stepDuration = this.step.getDuration();
        if (this.stepIndex == 0) {
            for (AnimationActor actor : this.actors.values()) {
                actor.reset();
            }
        }
        for (AnimationAction action : this.step.getActions()) {
            action.startAction(this.actors.get(action.getActor()), this.step);
        }
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        for (AnimationActor actor : this.actors.values()) {
            if (!actor.isVisible()) continue;
            double x = (double)((float)this.getX() + (float)this.getWidth() / 2.0f) + actor.getX(pPartialTick);
            double y = (double)((float)this.getY() + (float)this.getHeight() / 2.0f) + actor.getY(pPartialTick);
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_85837_(x, y, 0.0);
            actor.render(pGuiGraphics, pMouseX - Mth.m_14107_((double)x), pMouseY - Mth.m_14107_((double)y), pPartialTick);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }
}

