/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.animation;

import com.google.gson.JsonObject;
import us.amon.stormward.screen.book.element.animation.AnimationAction;
import us.amon.stormward.screen.book.element.animation.AnimationActor;
import us.amon.stormward.screen.book.element.animation.AnimationStep;
import us.amon.stormward.screen.book.element.animation.ParticleEmitterActor;

public class EmitAction
extends AnimationAction {
    private final int amount;
    private final int interval;
    private final double xSpread;
    private final double ySpread;
    private final double xDist;
    private final double yDist;
    private final double xDistSpread;
    private final double yDistSpread;
    private final boolean absolute;
    private ParticleEmitterActor actor;

    public EmitAction(String pActor, JsonObject pActionJson) {
        super(pActor);
        this.amount = pActionJson.has("amount") ? pActionJson.get("amount").getAsInt() : 1;
        this.interval = pActionJson.has("interval") ? pActionJson.get("interval").getAsInt() : 1;
        this.xSpread = pActionJson.has("x_spread") ? (double)pActionJson.get("x_spread").getAsInt() : 0.0;
        this.ySpread = pActionJson.has("y_spread") ? (double)pActionJson.get("y_spread").getAsInt() : 0.0;
        this.xDist = pActionJson.has("x_distance") ? (double)pActionJson.get("x_distance").getAsInt() : 0.0;
        this.yDist = pActionJson.has("y_distance") ? (double)pActionJson.get("y_distance").getAsInt() : 0.0;
        this.xDistSpread = pActionJson.has("x_distance_spread") ? (double)pActionJson.get("x_distance_spread").getAsInt() : 0.0;
        this.yDistSpread = pActionJson.has("y_distance_spread") ? (double)pActionJson.get("y_distance_spread").getAsInt() : 0.0;
        this.absolute = pActionJson.has("absolute") && pActionJson.get("absolute").getAsBoolean();
    }

    @Override
    public void startAction(AnimationActor pActor, AnimationStep pStep) {
        if (pActor instanceof ParticleEmitterActor) {
            ParticleEmitterActor particleActor;
            this.actor = particleActor = (ParticleEmitterActor)pActor;
        }
    }

    @Override
    public void tickAction(AnimationActor pActor, int pStepTime) {
        if (this.actor != null && pStepTime % this.interval == 0) {
            for (int i = 0; i < this.amount; ++i) {
                double startX = (this.actor.random.m_188500_() - 0.5) * 2.0 * this.xSpread;
                double startY = (this.actor.random.m_188500_() - 0.5) * 2.0 * this.ySpread;
                double endX = this.xDist + (this.actor.random.m_188500_() - 0.5) * 2.0 * this.xDistSpread;
                double endY = this.yDist + (this.actor.random.m_188500_() - 0.5) * 2.0 * this.yDistSpread;
                if (!this.absolute) {
                    endX += startX;
                    endY += startY;
                }
                this.actor.emit(startX, startY, endX, endY);
            }
        }
    }
}

