/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.animation;

import com.google.gson.JsonObject;
import net.minecraft.util.Mth;
import us.amon.stormward.screen.book.element.animation.AnimationAction;
import us.amon.stormward.screen.book.element.animation.AnimationActor;
import us.amon.stormward.screen.book.element.animation.AnimationStep;

public class MoveAction
extends AnimationAction {
    private final boolean updateX;
    private final boolean updateY;
    private final double endX;
    private final double endY;
    private final MovementType movementType;
    private float stepDuration;
    private double startX;
    private double startY;

    public MoveAction(String pActor, JsonObject pActionJson) {
        super(pActor);
        this.updateX = pActionJson.has("x");
        this.endX = this.updateX ? pActionJson.get("x").getAsDouble() : 0.0;
        this.updateY = pActionJson.has("y");
        this.endY = this.updateY ? pActionJson.get("y").getAsDouble() : 0.0;
        this.movementType = MovementType.fromJson(pActionJson);
    }

    @Override
    public void startAction(AnimationActor pActor, AnimationStep pStep) {
        this.stepDuration = pStep.getDuration();
        if (this.stepDuration <= 0.0f) {
            this.startX = this.endX;
            this.startY = this.endY;
            if (this.updateX) {
                pActor.setX(this.endX);
            }
            if (this.updateY) {
                pActor.setY(this.endY);
            }
        } else {
            this.startX = pActor.x;
            this.startY = pActor.y;
        }
    }

    @Override
    public void tickAction(AnimationActor pActor, int pStepTime) {
        double percent = this.movementType.apply((float)pStepTime / this.stepDuration);
        if (this.updateX) {
            pActor.setXSmooth(Mth.m_14139_((double)percent, (double)this.startX, (double)this.endX));
        }
        if (this.updateY) {
            pActor.setYSmooth(Mth.m_14139_((double)percent, (double)this.startY, (double)this.endY));
        }
    }

    @Override
    public void endAction(AnimationActor pActor) {
        super.endAction(pActor);
        if (this.updateX) {
            pActor.setX(this.endX);
        }
        if (this.updateY) {
            pActor.setY(this.endY);
        }
    }

    public static enum MovementType {
        LINEAR,
        EASE_IN,
        EASE_OUT,
        EASE_IN_OUT;


        public static MovementType fromJson(JsonObject pJson) {
            if (pJson.has("movement_type")) {
                return switch (pJson.get("movement_type").getAsString()) {
                    case "ease_in" -> EASE_IN;
                    case "ease_out" -> EASE_OUT;
                    case "ease_in_out" -> EASE_IN_OUT;
                    default -> LINEAR;
                };
            }
            return LINEAR;
        }

        public double apply(double pPercent) {
            return switch (this) {
                case EASE_IN -> 1.0 - Math.cos(pPercent * Math.PI / 2.0);
                case EASE_OUT -> Math.sin(pPercent * Math.PI / 2.0);
                case EASE_IN_OUT -> -(Math.cos(Math.PI * pPercent) - 1.0) / 2.0;
                default -> pPercent;
            };
        }
    }
}

