/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.obtaining;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.obtaining.ObtainingPageElement;
import us.amon.stormward.screen.book.element.resources.EntitiesElement;
import us.amon.stormward.screen.book.element.resources.ItemsElement;
import us.amon.stormward.screen.book.element.resources.ItemsOutputElement;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;

public class EntityLootPageElement
extends ObtainingPageElement<EntitiesElement, ItemsElement> {
    public static final ResourceLocation TOOL_SWORD_LOCATION = new ResourceLocation("stormward", "book/obtaining_sword");
    boolean shouldUpdateCount;

    public EntityLootPageElement(Book pBook, JsonObject pElementJson) {
        super(pBook, pElementJson);
    }

    @Override
    protected String getLeftKey() {
        return "entities";
    }

    @Override
    protected String getRightKey() {
        return "items";
    }

    @Override
    protected EntitiesElement createLeftElement(Book pBook, JsonElement pElementJson) {
        return new EntitiesElement(pBook, pElementJson, 38, 54);
    }

    @Override
    protected ItemsElement createRightElement(Book pBook, JsonElement pElementJson) {
        return new ItemsOutputElement(pBook, pElementJson, 16, 16);
    }

    @Override
    protected void initElements() {
        for (ResourcesElement.ResourceData resource : ((EntitiesElement)this.leftElement).getResources()) {
            if (resource.getMax() <= 1) continue;
            this.shouldUpdateCount = true;
            this.updateItemCountFromEntity();
        }
        for (ResourcesElement.ResourceData resource : ((ItemsElement)this.rightElement).getResources()) {
            resource.setScale(1.0f);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.shouldUpdateCount) {
            this.updateItemCountFromEntity();
        }
    }

    private void updateItemCountFromEntity() {
        ((ItemsElement.ItemData)((ItemsElement)this.rightElement).getResource()).setMin(((EntitiesElement.EntityData)((EntitiesElement)this.leftElement).getResource()).getMin());
        ((ItemsElement.ItemData)((ItemsElement)this.rightElement).getResource()).setMax(((EntitiesElement.EntityData)((EntitiesElement)this.leftElement).getResource()).getMax());
    }

    @Override
    protected void renderToolIcon(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_292816_(TOOL_SWORD_LOCATION, 0, 0, 12, 12);
    }
}

