/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.obtaining;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.Element;
import us.amon.stormward.screen.book.element.PageElement;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;

public abstract class ObtainingPageElement<T extends ResourcesElement<?>, S extends ResourcesElement<?>>
extends PageElement {
    public static final ResourceLocation OBTAINING_ARROW_LOCATION = new ResourceLocation("stormward", "book/obtaining_arrow");
    protected static final int ARROW_WIDTH = 24;
    protected static final int ARROW_HEIGHT = 14;
    protected static final int TOOL_WIDTH = 12;
    protected static final int TOOL_HEIGHT = 12;
    protected static final int DEFAULT_LEFT_WIDTH = 54;
    protected static final int DEFAULT_LEFT_HEIGHT = 54;
    protected static final int DEFAULT_RIGHT_WIDTH = 16;
    protected static final int DEFAULT_RIGHT_HEIGHT = 16;
    protected final T leftElement;
    protected final S rightElement;
    private int arrowX;

    public ObtainingPageElement(Book pBook, JsonObject pElementJson) {
        super(pBook, pElementJson);
        this.leftElement = this.createLeftElement(pBook, pElementJson.get(this.getLeftKey()));
        this.rightElement = this.createRightElement(pBook, pElementJson.get(this.getRightKey()));
        this.initElements();
    }

    protected String getLeftKey() {
        return "left";
    }

    protected String getRightKey() {
        return "right";
    }

    protected abstract T createLeftElement(Book var1, JsonElement var2);

    protected void initElements() {
    }

    protected abstract S createRightElement(Book var1, JsonElement var2);

    @Override
    public void setX(int pX) {
        super.setX(pX);
        int width = ((ResourcesElement)this.leftElement).getWidth() + 24 + ((ResourcesElement)this.rightElement).getWidth();
        int margin = (this.getWidth() - width) / 2;
        ((Element)this.leftElement).setX(pX + margin);
        this.arrowX = ((Element)this.leftElement).getX() + ((ResourcesElement)this.leftElement).getWidth();
        ((Element)this.rightElement).setX(this.arrowX + 24);
    }

    @Override
    public void setY(int pY) {
        super.setY(pY);
        ((Element)this.leftElement).setY(pY + (this.getHeight() - ((ResourcesElement)this.leftElement).getHeight()) / 2);
        ((Element)this.rightElement).setY(pY + (this.getHeight() - ((ResourcesElement)this.rightElement).getHeight()) / 2);
    }

    @Override
    public void tick() {
        super.tick();
        ((ResourcesElement)this.leftElement).tick();
        ((ResourcesElement)this.rightElement).tick();
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)this.getArrowX(), (float)this.getArrowY(), 0.0f);
        this.renderArrowIcon(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280168_().m_85849_();
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)this.getToolX(), (float)this.getToolY(), 0.0f);
        this.renderToolIcon(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280168_().m_85849_();
        ((ResourcesElement)this.leftElement).render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        ((ResourcesElement)this.rightElement).render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected int getArrowX() {
        return this.arrowX;
    }

    protected int getArrowY() {
        return this.getY() + (this.getHeight() - 14 - 12) / 2;
    }

    protected void renderArrowIcon(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_292816_(OBTAINING_ARROW_LOCATION, 0, 0, 24, 14);
    }

    protected int getToolX() {
        return this.arrowX + 6;
    }

    protected int getToolY() {
        return this.getY() + (this.getHeight() - 14 - 12) / 2 + 14;
    }

    protected abstract void renderToolIcon(GuiGraphics var1, int var2, int var3, float var4);

    @Override
    public boolean mouseClicked(double pX, double pY, int pButton) {
        return ((Element)this.leftElement).mouseClicked(pX, pY, pButton) || ((Element)this.rightElement).mouseClicked(pX, pY, pButton) || super.mouseClicked(pX, pY, pButton);
    }

    @Override
    public void addWidgets() {
        super.addWidgets();
        ((ResourcesElement)this.leftElement).addWidgets();
        ((ResourcesElement)this.rightElement).addWidgets();
    }

    @Override
    public void removeWidgets() {
        super.removeWidgets();
        ((ResourcesElement)this.leftElement).removeWidgets();
        ((ResourcesElement)this.rightElement).removeWidgets();
    }
}

