/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.Lighting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.resources.IsometricResourcesElement;

public class BlocksElement
extends IsometricResourcesElement<BlockData> {
    public BlocksElement(Book pBook, JsonElement pElementJson, int pWidth, int pHeight) {
        super(pBook, pElementJson, pWidth, pHeight);
    }

    @Override
    protected String getResourceKey() {
        return "blocks";
    }

    @Override
    protected BlockData loadResource(Book pBook, JsonElement pResourceJson) {
        if (pResourceJson.isJsonObject()) {
            return new BlockData(pBook, pResourceJson.getAsJsonObject());
        }
        return new BlockData(pBook, pResourceJson.getAsString());
    }

    @Override
    protected void renderResource(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderResource(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        BlocksElement.renderBlock(pGuiGraphics, ((BlockData)this.resource).getState());
    }

    public static void renderBlock(GuiGraphics pGuiGraphics, BlockState pState) {
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(-0.5f, -0.5f, -0.5f);
        Lighting.m_166384_();
        BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
        BakedModel model = renderer.m_110910_(pState);
        RenderType renderType = model.getRenderTypes(pState, RandomSource.m_216335_((long)42L), ModelData.EMPTY).contains(RenderType.m_110466_()) ? Sheets.m_110792_() : null;
        renderer.renderSingleBlock(pState, pGuiGraphics.m_280168_(), (MultiBufferSource)pGuiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
        pGuiGraphics.m_280262_();
        pGuiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    public static class BlockData
    extends IsometricResourcesElement.IsometricResourceData {
        protected final ResourceLocation blockId;
        protected final BlockState state;

        public BlockData(Book pBook, JsonObject pBlockJson) {
            super(pBook, pBlockJson);
            this.state = pBook.getStateFromString(pBlockJson.get("block").getAsString());
            this.blockId = pBook.getIdFromBlock(this.state.m_60734_());
        }

        public BlockData(Book pBook, String pBlockString) {
            super(pBook);
            this.state = pBook.getStateFromString(pBlockString);
            this.blockId = pBook.getIdFromBlock(this.state.m_60734_());
        }

        @Override
        protected float getDefaultScale() {
            return 20.0f;
        }

        @Override
        protected float getDefaultAngleY() {
            return 3.926991f;
        }

        public BlockState getState() {
            return this.state;
        }

        @Override
        public ResourceLocation getResourceId() {
            return this.blockId;
        }
    }
}

