/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.chapter.ChapterButton;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;

public class CraftingRecipesElement
extends ResourcesElement<RecipeData> {
    public static final ResourceLocation CRAFTING_BACKGROUND_LOCATION = new ResourceLocation("stormward", "book/crafting_grid");
    private final List<ChapterButton> buttons = new ArrayList<ChapterButton>();

    public CraftingRecipesElement(Book pBook, JsonElement pElementJson, int pWidth, int pHeight) {
        super(pBook, pElementJson, pWidth, pHeight);
    }

    @Override
    protected String getResourceKey() {
        return "recipes";
    }

    @Override
    protected RecipeData loadResource(Book pBook, JsonElement pResourceJson) {
        if (pResourceJson.isJsonObject()) {
            return new RecipeData(pBook, pResourceJson.getAsJsonObject());
        }
        return new RecipeData(pBook, new ResourceLocation(pResourceJson.getAsString()));
    }

    @Override
    protected void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_292816_(CRAFTING_BACKGROUND_LOCATION, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    protected void renderResource(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.forIngredients(((RecipeData)this.resource).getRecipe(), (ingredient, x, y) -> this.renderIngredient(pGuiGraphics, ingredient, x, y));
    }

    protected void renderIngredient(GuiGraphics pGuiGraphics, Ingredient pIngredient, int pX, int pY) {
        if (!pIngredient.m_43947_()) {
            pGuiGraphics.m_280480_(pIngredient.m_43908_()[this.tickCount / ((RecipeData)this.resource).interval % pIngredient.m_43908_().length], pX, pY);
        }
    }

    @Override
    public void addWidgets() {
        super.addWidgets();
        this.forIngredients(((RecipeData)this.resource).getRecipe(), this::addWidgetForIngredient);
    }

    public void addWidgetForIngredient(Ingredient pIngredient, int pX, int pY) {
        if (!pIngredient.m_43947_()) {
            for (ItemStack stack : pIngredient.m_43908_()) {
                ResourceLocation chapterId = this.book.getChapterForResource(this.book.getIdFromItem(stack.m_41720_()));
                if (!CraftingRecipesElement.canAddWidget(this.book, chapterId)) continue;
                this.buttons.add(this.book.addWidget(new ChapterButton(this.book, chapterId, Mth.m_14107_((double)this.getCornerX()) + pX, Mth.m_14107_((double)this.getCornerY()) + pY, 18, 18)));
            }
        }
    }

    @Override
    public void removeWidgets() {
        for (ChapterButton button : this.buttons) {
            this.book.removeWidget((GuiEventListener)button);
        }
        this.buttons.clear();
    }

    protected void forIngredients(Recipe<?> pRecipe, IngredientConsumer pConsumer) {
        if (pRecipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)pRecipe;
            this.forShapedIngredients(shapedRecipe, pConsumer);
        } else if (pRecipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)pRecipe;
            this.forUnshapedIngredients(shapelessRecipe, pConsumer);
        }
    }

    protected void forShapedIngredients(ShapedRecipe pShapedRecipe, IngredientConsumer pConsumer) {
        NonNullList ingredients = pShapedRecipe.m_7527_();
        for (int x = 0; x < pShapedRecipe.getRecipeWidth(); ++x) {
            for (int y = 0; y < pShapedRecipe.getRecipeHeight(); ++y) {
                pConsumer.accept((Ingredient)ingredients.get(y * pShapedRecipe.getRecipeWidth() + x), x * 18 - 26, y * 18 - 26);
            }
        }
    }

    protected void forUnshapedIngredients(ShapelessRecipe pShapelessRecipe, IngredientConsumer pConsumer) {
        NonNullList ingredients = pShapelessRecipe.m_7527_();
        for (int i = 0; i < ingredients.size(); ++i) {
            int x = i % 3;
            int y = i / 3;
            pConsumer.accept((Ingredient)ingredients.get(i), x * 18 - 26, y * 18 - 26);
        }
    }

    public static class RecipeData
    extends ResourcesElement.ResourceData {
        public final ResourceLocation recipeId;
        public final Recipe<?> recipe;
        public int interval;

        public RecipeData(Book pBook, JsonObject pRecipeJson) {
            super(pBook, pRecipeJson);
            this.recipeId = new ResourceLocation(pRecipeJson.get("recipe").getAsString());
            this.recipe = pBook.getRecipeFromId(this.recipeId);
            this.interval = pRecipeJson.has("interval") ? pRecipeJson.get("interval").getAsInt() : this.getDefaultInterval();
        }

        public RecipeData(Book pBook, ResourceLocation pRecipeId) {
            super(pBook);
            this.recipeId = pRecipeId;
            this.recipe = pBook.getRecipeFromId(this.recipeId);
            this.interval = this.getDefaultInterval();
        }

        protected int getDefaultInterval() {
            return 20;
        }

        public int getInterval() {
            return this.interval;
        }

        public void setInterval(int pInterval) {
            this.interval = pInterval;
        }

        public Recipe<?> getRecipe() {
            return this.recipe;
        }

        @Override
        public ResourceLocation getResourceId() {
            return this.recipeId;
        }

        @Override
        public ResourceLocation getChapterId() {
            return null;
        }
    }

    public static interface IngredientConsumer {
        public void accept(Ingredient var1, int var2, int var3);
    }
}

