/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.resources.IsometricResourcesElement;

public class EntitiesElement
extends IsometricResourcesElement<EntityData> {
    public static final Quaternionf CAMERA_ORIENTATION = new Quaternionf().rotateX(0.5235988f).rotateY(0.7853982f);
    public static final Quaternionf POSE = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)Math.PI).mul((Quaternionfc)CAMERA_ORIENTATION);

    public EntitiesElement(Book pBook, JsonElement pElementJson, int pWidth, int pHeight) {
        super(pBook, pElementJson, pWidth, pHeight);
    }

    @Override
    protected String getResourceKey() {
        return "entities";
    }

    @Override
    protected EntityData loadResource(Book pBook, JsonElement pResourceJson) {
        if (pResourceJson.isJsonObject()) {
            return new EntityData(pBook, pResourceJson.getAsJsonObject());
        }
        return new EntityData(pBook, new ResourceLocation(pResourceJson.getAsString()));
    }

    @Override
    public void tick() {
        super.tick();
        ((EntityData)this.resource).getEntity().f_19797_ = this.tickCount;
    }

    @Override
    protected void renderResource(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderResource(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (((EntityData)this.resource).getEntity() != null) {
            EntitiesElement.renderEntity(pGuiGraphics, pPartialTick, ((EntityData)this.resource).getEntity(), ((EntityData)this.resource).getCameraOrientiation());
        }
    }

    public static void renderEntity(GuiGraphics pGuiGraphics, float pPartialTick, Entity pEntity) {
        EntitiesElement.renderEntity(pGuiGraphics, pPartialTick, pEntity, CAMERA_ORIENTATION);
    }

    public static void renderEntity(GuiGraphics pGuiGraphics, float pPartialTick, Entity pEntity, Quaternionf pCameraOrientation) {
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85837_(0.0, (double)(-pEntity.m_20206_()) / 2.0, 0.0);
        Lighting.m_166384_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        dispatcher.m_252923_(pCameraOrientation.conjugate());
        dispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> dispatcher.m_114384_(pEntity, 0.0, 0.0, 0.0, 0.0f, pPartialTick, pGuiGraphics.m_280168_(), (MultiBufferSource)pGuiGraphics.m_280091_(), 0xF000F0));
        pGuiGraphics.m_280262_();
        dispatcher.m_114468_(true);
        pGuiGraphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    public static class EntityData
    extends IsometricResourcesElement.IsometricResourceData {
        protected final ResourceLocation entityId;
        protected final Entity entity;

        public EntityData(Book pBook, JsonObject pEntityJson) {
            super(pBook, pEntityJson);
            this.entityId = new ResourceLocation(pEntityJson.get("entity").getAsString());
            this.entity = pBook.getEntityFromJson(pEntityJson);
        }

        public EntityData(Book pBook, ResourceLocation pEntityId) {
            super(pBook);
            this.entityId = pEntityId;
            this.entity = pBook.getEntityFromId(pEntityId);
        }

        @Override
        protected float getDefaultScale() {
            return 30.0f;
        }

        public Entity getEntity() {
            return this.entity;
        }

        @Override
        public ResourceLocation getResourceId() {
            return this.entityId;
        }
    }
}

