/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.chapter.ChapterButton;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;

public class FabrialOutputsElement
extends ResourcesElement<FabrialOutputData> {
    public static final ResourceLocation FABRIAL_OUTPUT_BACKGROUND_LOCATION = new ResourceLocation("stormward", "book/fabrial_output_slots");
    public static final int ITEM_WIDTH = 16;
    public static final int ITEM_HEIGHT = 16;
    public static final int ELEMENT_HEIGHT = 36;
    private ChapterButton primaryButton;
    private ChapterButton secondaryButton;

    public FabrialOutputsElement(Book pBook) {
        super(pBook, new ArrayList(), 16, 36);
    }

    @Override
    protected FabrialOutputData loadResource(Book pBook, JsonElement pResourceJson) {
        return null;
    }

    @Override
    protected void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.hasSecondaryItem()) {
            pGuiGraphics.m_292816_(FABRIAL_OUTPUT_BACKGROUND_LOCATION, this.getX(), this.getY(), 16, 36);
        } else {
            pGuiGraphics.m_292816_(OUTPUT_BACKGROUND_LOCATION, this.getX(), this.getY() + 10, 16, 16);
        }
    }

    @Override
    protected void renderResource(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.hasSecondaryItem()) {
            pGuiGraphics.m_280480_(((FabrialOutputData)this.resource).getPrimaryStack(), -8, -18);
            pGuiGraphics.m_280480_(((FabrialOutputData)this.resource).getSecondaryStack(), -8, 2);
        } else {
            pGuiGraphics.m_280480_(((FabrialOutputData)this.resource).getPrimaryStack(), -8, -8);
        }
    }

    @Override
    public void addWidgets() {
        if (this.hasSecondaryItem()) {
            if (this.resource != null) {
                if (FabrialOutputsElement.canAddWidget(this.book, ((FabrialOutputData)this.resource).getChapterId())) {
                    this.primaryButton = this.book.addWidget(new ChapterButton(this.book, ((FabrialOutputData)this.resource).getChapterId(), this.getX(), this.getY(), 16, 16));
                }
                if (FabrialOutputsElement.canAddWidget(this.book, ((FabrialOutputData)this.resource).getSecondaryChapterId())) {
                    this.secondaryButton = this.book.addWidget(new ChapterButton(this.book, ((FabrialOutputData)this.resource).getSecondaryChapterId(), this.getX(), this.getY() + 20, 16, 16));
                }
            }
        } else {
            super.addWidgets();
        }
    }

    @Override
    public void removeWidgets() {
        if (this.hasSecondaryItem()) {
            if (this.primaryButton != null) {
                this.book.removeWidget((GuiEventListener)this.primaryButton);
            }
            if (this.secondaryButton != null) {
                this.book.removeWidget((GuiEventListener)this.secondaryButton);
            }
        } else {
            super.removeWidgets();
        }
    }

    public boolean hasSecondaryItem() {
        return this.getResource() != null && ((FabrialOutputData)this.getResource()).hasSecondaryItem();
    }

    public static class FabrialOutputData
    extends ResourcesElement.ResourceData {
        protected final ResourceLocation primaryId;
        protected final ItemStack primaryStack;
        protected final ResourceLocation secondaryId;
        protected final ItemStack secondaryStack;

        public FabrialOutputData(Book pBook, ItemStack pPrimaryStack, ItemStack pSecondaryStack) {
            super(pBook);
            this.primaryStack = pPrimaryStack;
            this.primaryId = pBook.getIdFromItem(this.primaryStack.m_41720_());
            this.secondaryStack = pSecondaryStack;
            this.secondaryId = this.secondaryStack != null ? pBook.getIdFromItem(this.secondaryStack.m_41720_()) : null;
        }

        public ItemStack getPrimaryStack() {
            return this.primaryStack;
        }

        public ItemStack getSecondaryStack() {
            return this.secondaryStack;
        }

        public boolean hasSecondaryItem() {
            return this.secondaryStack != null && !this.secondaryStack.m_41619_();
        }

        @Override
        public ResourceLocation getResourceId() {
            return this.primaryId;
        }

        public ResourceLocation getSecondaryChapterId() {
            return this.book.getChapterForResource(this.secondaryId);
        }
    }
}

