/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Axis;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;

public abstract class IsometricResourcesElement<T extends IsometricResourceData>
extends ResourcesElement<T> {
    private final float spin;

    public IsometricResourcesElement(Book pBook, JsonElement pElementJson, int pWidth, int pHeight) {
        super(pBook, pElementJson, pWidth, pHeight);
        this.spin = pElementJson.isJsonObject() && pElementJson.getAsJsonObject().has("spin") ? pElementJson.getAsJsonObject().get("spin").getAsFloat() : this.getDefaultSpin();
    }

    protected float getDefaultSpin() {
        return 0.0f;
    }

    @Override
    protected void renderResource(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, 1.0f, -1.0f));
        pGuiGraphics.m_280168_().m_252781_(((IsometricResourceData)this.resource).getPose());
        pGuiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(((float)this.tickCount + pPartialTick) * this.spin));
    }

    public static class IsometricResourceData
    extends ResourcesElement.ResourceData {
        protected final Quaternionf cameraOrientation;
        protected final Quaternionf pose;

        public IsometricResourceData(Book pBook, JsonObject pResourceJson) {
            super(pBook, pResourceJson);
            float angleX = pResourceJson.has("angle_x") ? pResourceJson.get("angle_x").getAsFloat() * ((float)Math.PI / 180) : this.getDefaultAngleX();
            float angleY = pResourceJson.has("angle_y") ? pResourceJson.get("angle_y").getAsFloat() * ((float)Math.PI / 180) : this.getDefaultAngleY();
            this.cameraOrientation = new Quaternionf().rotateX(angleX).rotateY(angleY);
            this.pose = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)Math.PI).mul((Quaternionfc)this.cameraOrientation);
        }

        public IsometricResourceData(Book pBook) {
            super(pBook);
            this.cameraOrientation = new Quaternionf().rotateX(this.getDefaultAngleX()).rotateY(this.getDefaultAngleY());
            this.pose = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)Math.PI).mul((Quaternionfc)this.cameraOrientation);
        }

        protected float getDefaultAngleX() {
            return 0.5235988f;
        }

        protected float getDefaultAngleY() {
            return 0.7853982f;
        }

        public Quaternionf getCameraOrientiation() {
            return this.cameraOrientation;
        }

        public Quaternionf getPose() {
            return this.pose;
        }
    }
}

