/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;

public class ItemsElement
extends ResourcesElement<ItemData> {
    public ItemsElement(Book pBook, JsonElement pElementJson, int pWidth, int pHeight) {
        super(pBook, pElementJson, pWidth, pHeight);
    }

    public ItemsElement(Book pBook, List<ItemData> pResources, int pWidth, int pHeight) {
        super(pBook, pResources, pWidth, pHeight);
    }

    @Override
    protected String getResourceKey() {
        return "items";
    }

    @Override
    protected ItemData loadResource(Book pBook, JsonElement pResourceJson) {
        if (pResourceJson.isJsonObject()) {
            return new ItemData(pBook, pResourceJson.getAsJsonObject());
        }
        return new ItemData(pBook, pResourceJson.getAsString());
    }

    @Override
    protected void renderResource(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280480_(((ItemData)this.resource).getStack(), -8, -8);
        if (((ItemData)this.resource).getMin() != ((ItemData)this.resource).getMax() || ((ItemData)this.resource).getMin() > 1) {
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            Object count = Integer.toString(((ItemData)this.resource).getMin());
            int x = 9 - this.book.getFont().m_92895_((String)count);
            if (((ItemData)this.resource).getMin() < ((ItemData)this.resource).getMax()) {
                count = ((ItemData)this.resource).getMin() + "-" + ((ItemData)this.resource).getMax();
                x = -this.book.getFont().m_92895_((String)count) / 2;
            }
            pGuiGraphics.m_280056_(this.book.getFont(), (String)count, x, 1, 0xFFFFFF, true);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }

    public static class ItemData
    extends ResourcesElement.ResourceData {
        protected final ResourceLocation itemId;
        protected final ItemStack stack;

        public ItemData(Book pBook, JsonObject pItemJson) {
            super(pBook, pItemJson);
            this.stack = pBook.getItemStackFromString(pItemJson.get("item").getAsString());
            this.itemId = pBook.getIdFromItem(this.stack.m_41720_());
        }

        public ItemData(Book pBook, String pItemString) {
            super(pBook);
            this.stack = pBook.getItemStackFromString(pItemString);
            this.itemId = pBook.getIdFromItem(this.stack.m_41720_());
        }

        public ItemData(Book pBook, ResourceLocation pItemId, ItemStack pStack) {
            super(pBook);
            this.itemId = pItemId;
            this.stack = pStack;
        }

        @Override
        protected float getDefaultScale() {
            return 2.0f;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public ResourceLocation getResourceId() {
            return this.itemId;
        }
    }
}

