/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.chapter.ChapterButton;
import us.amon.stormward.screen.book.element.Element;

public abstract class ResourcesElement<T extends ResourceData>
extends Element {
    public static final ResourceLocation OUTPUT_BACKGROUND_LOCATION = new ResourceLocation("stormward", "book/result_background");
    private final int width;
    private final int height;
    private final List<T> resources;
    private final List<Integer> order;
    private int interval;
    protected int tickCount;
    protected T resource;
    private ChapterButton button;

    public ResourcesElement(Book pBook, JsonElement pElementJson, int pWidth, int pHeight) {
        super(pBook);
        this.width = pWidth;
        this.height = pHeight;
        if (pElementJson.isJsonObject()) {
            JsonObject elementObject = pElementJson.getAsJsonObject();
            this.interval = elementObject.has("interval") ? elementObject.get("interval").getAsInt() : 20;
            this.resources = elementObject.has(this.getResourceKey()) ? this.loadResources(pBook, elementObject.get(this.getResourceKey())) : this.loadResources(pBook, (JsonElement)elementObject);
            this.order = new ArrayList<Integer>();
            if (elementObject.has("order")) {
                for (JsonElement element : elementObject.getAsJsonArray("order")) {
                    this.order.add(element.getAsInt());
                }
            }
        } else {
            this.interval = 20;
            this.resources = this.loadResources(pBook, pElementJson);
            this.order = new ArrayList<Integer>();
        }
        this.initResources();
    }

    public ResourcesElement(Book pBook, List<T> pResources, int pWidth, int pHeight) {
        super(pBook);
        this.width = pWidth;
        this.height = pHeight;
        this.interval = 20;
        this.resources = pResources;
        this.order = new ArrayList<Integer>();
    }

    protected ArrayList<T> loadResources(Book pBook, JsonElement pResourcesJson) {
        ArrayList<T> resources = new ArrayList<T>();
        if (pResourcesJson.isJsonArray()) {
            for (JsonElement element : pResourcesJson.getAsJsonArray()) {
                resources.add(this.loadResource(pBook, element));
            }
        } else {
            resources.add(this.loadResource(pBook, pResourcesJson));
        }
        return resources;
    }

    public void initResources() {
        this.resource = (ResourceData)this.resources.get(this.order.isEmpty() ? 0 : this.order.get(0));
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int pInterval) {
        this.interval = pInterval;
    }

    protected String getResourceKey() {
        return "resources";
    }

    protected abstract T loadResource(Book var1, JsonElement var2);

    public List<T> getResources() {
        return this.resources;
    }

    public T getResource() {
        return this.resource;
    }

    public List<Integer> getOrder() {
        return this.order;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void tick() {
        ++this.tickCount;
        if (!this.resources.isEmpty()) {
            int index = this.tickCount / this.interval;
            ResourceData nextResource = (ResourceData)this.resources.get(!this.order.isEmpty() ? this.order.get(index % this.order.size()) : index % this.resources.size());
            if (nextResource != this.resource) {
                this.setResource(nextResource);
            }
        }
    }

    void setResource(T pResource) {
        this.removeWidgets();
        this.resource = pResource;
        this.addWidgets();
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.resource != null) {
            pGuiGraphics.m_280168_().m_85836_();
            double x = this.getCornerX();
            double y = this.getCornerY();
            pGuiGraphics.m_280168_().m_85837_(x, y, 50.0);
            pGuiGraphics.m_280168_().m_85841_(((ResourceData)this.resource).getScale(), ((ResourceData)this.resource).getScale(), ((ResourceData)this.resource).getScale());
            this.renderResource(pGuiGraphics, pMouseX - Mth.m_14107_((double)x), pMouseY - Mth.m_14107_((double)y), pPartialTick);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }

    protected void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public double getCornerX() {
        return (float)this.getX() + (float)this.getWidth() / 2.0f + ((ResourceData)this.resource).getXOffset();
    }

    public double getCornerY() {
        return (float)this.getY() + (float)this.getHeight() / 2.0f + ((ResourceData)this.resource).getYOffset();
    }

    protected abstract void renderResource(GuiGraphics var1, int var2, int var3, float var4);

    @Override
    public void addWidgets() {
        if (this.resource != null && ResourcesElement.canAddWidget(this.book, ((ResourceData)this.resource).getChapterId())) {
            this.button = this.book.addWidget(new ChapterButton(this.book, ((ResourceData)this.resource).getChapterId(), this.getX(), this.getY(), this.getWidth(), this.getHeight()));
        }
    }

    protected static boolean canAddWidget(Book pBook, ResourceLocation pChapterId) {
        return pChapterId != null && !pChapterId.equals((Object)pBook.getCurrentChapter());
    }

    @Override
    public void removeWidgets() {
        if (this.button != null) {
            this.book.removeWidget((GuiEventListener)this.button);
        }
    }

    public static class ResourceData {
        protected final Book book;
        protected final float xOffset;
        protected final float yOffset;
        protected final ResourceLocation chapterId;
        protected float scale;
        private int min;
        private int max;

        public ResourceData(Book pBook, JsonObject pResourceJson) {
            this.book = pBook;
            this.scale = pResourceJson.has("scale") ? pResourceJson.get("scale").getAsFloat() : this.getDefaultScale();
            this.xOffset = pResourceJson.has("x_offset") ? pResourceJson.get("x_offset").getAsFloat() : this.getDefaultXOffset();
            float f = this.yOffset = pResourceJson.has("y_offset") ? pResourceJson.get("y_offset").getAsFloat() : this.getDefaultYOffset();
            this.min = pResourceJson.has("min") ? pResourceJson.get("min").getAsInt() : (pResourceJson.has("count") ? pResourceJson.get("count").getAsInt() : 1);
            this.max = pResourceJson.has("max") ? pResourceJson.get("max").getAsInt() : this.min;
            this.chapterId = pResourceJson.has("chapter_id") ? new ResourceLocation(pBook.getNamespace(), pResourceJson.get("chapter_id").getAsString()) : null;
        }

        public ResourceData(Book pBook) {
            this.book = pBook;
            this.scale = this.getDefaultScale();
            this.xOffset = this.getDefaultXOffset();
            this.yOffset = this.getDefaultYOffset();
            this.min = 1;
            this.max = 1;
            this.chapterId = null;
        }

        protected float getDefaultScale() {
            return 1.0f;
        }

        protected float getDefaultXOffset() {
            return 0.0f;
        }

        protected float getDefaultYOffset() {
            return 0.0f;
        }

        public float getScale() {
            return this.scale;
        }

        public void setScale(float pScale) {
            this.scale = pScale;
        }

        public float getXOffset() {
            return this.xOffset;
        }

        public float getYOffset() {
            return this.yOffset;
        }

        public ResourceLocation getResourceId() {
            return null;
        }

        public ResourceLocation getChapterId() {
            return this.book.getChapterForResource(this.chapterId != null ? this.chapterId : this.getResourceId());
        }

        public int getMin() {
            return this.min;
        }

        public void setMin(int pMin) {
            this.min = pMin;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int pMax) {
            this.max = pMax;
        }
    }
}

