/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.PageElement;
import us.amon.stormward.screen.book.element.resources.BlocksElement;
import us.amon.stormward.screen.book.element.resources.EntitiesElement;
import us.amon.stormward.screen.book.element.resources.ItemsElement;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;
import us.amon.stormward.screen.book.element.resources.StructuresElement;

public class ResourcesPageElement
extends PageElement {
    private final ResourcesElement<?> element;

    public ResourcesPageElement(Book pBook, JsonObject pElementJson) {
        super(pBook, pElementJson);
        this.element = switch (pElementJson.get("type").getAsString()) {
            case "blocks" -> new BlocksElement(pBook, (JsonElement)pElementJson, this.getWidth(), this.getHeight());
            case "entities" -> new EntitiesElement(pBook, (JsonElement)pElementJson, this.getWidth(), this.getHeight());
            case "structures" -> new StructuresElement(pBook, (JsonElement)pElementJson, this.getWidth(), this.getHeight());
            default -> new ItemsElement(pBook, (JsonElement)pElementJson, this.getWidth(), this.getHeight());
        };
    }

    @Override
    public PageElement.Size getDefaultSize(JsonObject pElementJson) {
        return switch (pElementJson.get("type").getAsString()) {
            case "entities", "structures" -> PageElement.Size.LARGE;
            default -> PageElement.Size.SMALL;
        };
    }

    @Override
    public void setX(int pX) {
        super.setX(pX);
        this.element.setX(pX);
    }

    @Override
    public void setY(int pY) {
        super.setY(pY);
        this.element.setY(pY);
    }

    @Override
    public void tick() {
        super.tick();
        this.element.tick();
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.element.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    public boolean mouseClicked(double pX, double pY, int pButton) {
        return this.element.mouseClicked(pX, pY, pButton) || super.mouseClicked(pX, pY, pButton);
    }

    @Override
    public void addWidgets() {
        super.addWidgets();
        this.element.addWidgets();
    }

    @Override
    public void removeWidgets() {
        super.removeWidgets();
        this.element.removeWidgets();
    }
}

