/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.chapter.ChapterButton;
import us.amon.stormward.screen.book.element.resources.FabrialRecipesElement;
import us.amon.stormward.screen.book.element.resources.ItemsElement;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;

public class SoulcasterRecipesElement
extends ResourcesElement<FabrialData> {
    public static final ResourceLocation SOULCASTER_CHAPTER_ID = new ResourceLocation("stormward", "items/soulcaster");
    private final ItemStack soulcaster = new ItemStack((ItemLike)StormwardItems.SOULCASTER.get());
    private ChapterButton fabrialButton;
    private ChapterButton soulcasterButton;

    public SoulcasterRecipesElement(Book pBook, JsonElement pElementJson, int pWidth, int pHeight) {
        super(pBook, pElementJson, pWidth, pHeight);
        StormlightStorageHelper.setFull((ICapabilityProvider)this.soulcaster);
    }

    @Override
    protected String getResourceKey() {
        return "fabrials";
    }

    @Override
    protected FabrialData loadResource(Book pBook, JsonElement pResourceJson) {
        if (pResourceJson.isJsonObject()) {
            return new FabrialData(pBook, pResourceJson.getAsJsonObject());
        }
        return new FabrialData(pBook, pResourceJson.getAsString());
    }

    @Override
    protected void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_292816_(FabrialRecipesElement.FABRIAL_BACKGROUND_LOCATION, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    protected void renderResource(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280480_(((FabrialData)this.resource).getStack(), -8, -26);
        pGuiGraphics.m_280480_(this.soulcaster, -18, 10);
    }

    @Override
    public void addWidgets() {
        if (this.resource != null && SoulcasterRecipesElement.canAddWidget(this.book, ((FabrialData)this.resource).getChapterId())) {
            this.fabrialButton = this.book.addWidget(new ChapterButton(this.book, ((FabrialData)this.resource).getChapterId(), Mth.m_14107_((double)this.getCornerX()) - 8, Mth.m_14107_((double)this.getCornerY()) - 26, 18, 18));
        }
        if (SoulcasterRecipesElement.canAddWidget(this.book, SOULCASTER_CHAPTER_ID)) {
            this.soulcasterButton = this.book.addWidget(new ChapterButton(this.book, SOULCASTER_CHAPTER_ID, Mth.m_14107_((double)this.getCornerX()) - 18, Mth.m_14107_((double)this.getCornerY()) + 10, 18, 18));
        }
    }

    @Override
    public void removeWidgets() {
        if (this.fabrialButton != null) {
            this.book.removeWidget((GuiEventListener)this.fabrialButton);
        }
        if (this.soulcasterButton != null) {
            this.book.removeWidget((GuiEventListener)this.soulcasterButton);
        }
    }

    public static class FabrialData
    extends ItemsElement.ItemData {
        public FabrialData(Book pBook, JsonObject pItemJson) {
            super(pBook, pItemJson);
        }

        public FabrialData(Book pBook, String pItemString) {
            super(pBook, pItemString);
        }

        @Override
        protected float getDefaultScale() {
            return 1.0f;
        }
    }
}

