/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.screen.book.element.resources.StructuresChunkGetter;

public class StructuresLevel
implements BlockAndTintGetter {
    private final LevelLightEngine lightEngine;
    private final RandomSource random;
    private BlockState[][][] blockStates;
    private Biome biome;

    public StructuresLevel(BlockState[][][] pBlockStates) {
        this(pBlockStates, null);
    }

    public StructuresLevel(BlockState[][][] pBlockStates, Biome pBiome) {
        this.blockStates = pBlockStates;
        this.biome = pBiome != null ? pBiome : new Biome.BiomeBuilder().m_47592_();
        this.lightEngine = new LevelLightEngine((LightChunkGetter)new StructuresChunkGetter(this), true, true);
        this.random = RandomSource.m_216327_();
    }

    public void setBlockStates(BlockState[][][] pBlockStates) {
        this.blockStates = pBlockStates;
    }

    public void setBiome(Biome pBiome) {
        this.biome = pBiome;
    }

    public float m_7717_(@NotNull Direction pDirection, boolean pShade) {
        return switch (pDirection) {
            case Direction.DOWN -> 0.5f;
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            case Direction.WEST, Direction.EAST -> 0.6f;
            default -> 1.0f;
        };
    }

    @NotNull
    public LevelLightEngine m_5518_() {
        return this.lightEngine;
    }

    public int m_6171_(@NotNull BlockPos pBlockPos, @NotNull ColorResolver pColorResolver) {
        return pColorResolver.m_130045_(this.biome, (double)pBlockPos.m_123341_(), (double)pBlockPos.m_123343_());
    }

    @Nullable
    public BlockEntity m_7702_(@NotNull BlockPos pPos) {
        return null;
    }

    @NotNull
    public BlockState m_8055_(@NotNull BlockPos pPos) {
        if (pPos.m_123341_() >= 0 && pPos.m_123341_() < this.blockStates[0][0].length && pPos.m_123343_() >= 0 && pPos.m_123343_() < this.blockStates[0].length && pPos.m_123342_() >= 0 && pPos.m_123342_() < this.blockStates.length) {
            return this.blockStates[pPos.m_123342_()][pPos.m_123343_()][pPos.m_123341_()];
        }
        return Blocks.f_50016_.m_49966_();
    }

    @NotNull
    public FluidState m_6425_(@NotNull BlockPos pPos) {
        return this.m_8055_(pPos).m_60819_();
    }

    public int m_141928_() {
        return this.blockStates.length;
    }

    public int m_141937_() {
        return 0;
    }

    public int m_45517_(@NotNull LightLayer pLightType, @NotNull BlockPos pBlockPos) {
        return 15;
    }

    public void render(GuiGraphics pGuiGraphics) {
        BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < this.blockStates.length; ++y) {
            for (int z = 0; z < this.blockStates[y].length; ++z) {
                for (int x = 0; x < this.blockStates[y][z].length; ++x) {
                    pos.m_122178_(x, y, z);
                    BlockState state = this.blockStates[y][z][x];
                    if (state.m_60799_() == RenderShape.INVISIBLE) continue;
                    BakedModel model = renderer.m_110910_(state);
                    ModelData modelData = model.getModelData((BlockAndTintGetter)this, (BlockPos)pos, state, ModelData.EMPTY);
                    this.random.m_188584_(state.m_60726_((BlockPos)pos));
                    for (RenderType renderType : model.getRenderTypes(state, this.random, modelData)) {
                        VertexConsumer vertexConsumer = pGuiGraphics.m_280091_().m_6299_(renderType);
                        pGuiGraphics.m_280168_().m_85836_();
                        pGuiGraphics.m_280168_().m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                        renderer.renderBatched(state, (BlockPos)pos, (BlockAndTintGetter)this, pGuiGraphics.m_280168_(), vertexConsumer, true, this.random, modelData, renderType);
                        pGuiGraphics.m_280168_().m_85849_();
                    }
                }
            }
        }
    }
}

