/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.part;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.chapter.Chapter;
import us.amon.stormward.screen.book.chapter.IndexChapter;
import us.amon.stormward.screen.book.icon.Icon;
import us.amon.stormward.screen.book.part.Part;

public class IndexedPart
extends Part {
    private final Chapter indexChapter;
    private final Component title;
    private final List<ResourceLocation> chapters;
    private final Icon icon;
    private final int color;
    private Chapter chapter;
    private int chapterNum;

    public IndexedPart(Book pBook, Component pTitle, JsonObject pPartJson) {
        super(pBook);
        this.title = pTitle;
        this.icon = Icon.getIconFromJson(this.book, pPartJson.getAsJsonObject("icon"));
        this.color = pPartJson.get("color").getAsInt();
        this.indexChapter = new IndexChapter(this.book, this);
        this.chapters = new ArrayList<ResourceLocation>();
        pPartJson.get("chapters").getAsJsonArray().forEach(element -> this.chapters.add(new ResourceLocation(pBook.getNamespace(), element.getAsString())));
    }

    @Override
    public boolean hasChapter(ResourceLocation pChapterId) {
        return this.chapters.contains(pChapterId);
    }

    @Override
    public void setChapter(ResourceLocation pChapterId) {
        if (this.hasChapter(pChapterId)) {
            this.setChapter(this.chapters.indexOf(pChapterId) + 1, true);
        }
    }

    public void setChapter(int pIndex, boolean pFlipToFront) {
        if (this.chapter != null) {
            this.chapter.flipAway();
        }
        if (pIndex <= 0) {
            this.chapterNum = 0;
            this.chapter = this.indexChapter;
        } else {
            this.chapterNum = pIndex;
            this.chapter = this.book.getChapterFromId(this.chapters.get(this.chapterNum - 1));
        }
        if (pFlipToFront) {
            this.chapter.flipToFront();
        } else {
            this.chapter.flipToBack();
        }
        this.book.updateBookmarkPositions();
        this.book.screen.updateButtonVisibility();
    }

    @Override
    public ResourceLocation getCurrentChapter() {
        return this.chapterNum <= 0 ? null : this.chapters.get(this.chapterNum - 1);
    }

    @Override
    public List<ResourceLocation> getChapters() {
        return this.chapters;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public void tick() {
        this.chapter.tick();
    }

    @Override
    public void flipToFront() {
        this.setChapter(0, true);
    }

    @Override
    public void flipToBack() {
        this.setChapter(this.chapters.size(), false);
    }

    @Override
    public void flipAway() {
        this.chapter.flipAway();
    }

    @Override
    public boolean hasNext() {
        return this.chapter.hasNext() || this.chapterNum < this.chapters.size();
    }

    @Override
    public void next() {
        if (this.chapter.hasNext()) {
            this.chapter.next();
        } else if (this.hasNext()) {
            this.setChapter(this.chapterNum + 1, true);
        }
    }

    @Override
    public boolean hasPrevious() {
        return this.chapter.hasPrevious() || this.chapterNum > 0;
    }

    @Override
    public void previous() {
        if (this.chapter.hasPrevious()) {
            this.chapter.previous();
        } else if (this.hasPrevious()) {
            this.setChapter(this.chapterNum - 1, false);
        }
    }

    @Override
    public void refresh() {
        this.chapter.refresh();
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.chapter.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    public boolean mouseClicked(double pX, double pY, int pButton) {
        return this.chapter.mouseClicked(pX, pY, pButton);
    }
}

