/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.weather;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import us.amon.stormward.Config;
import us.amon.stormward.damage.StormwardDamageSources;
import us.amon.stormward.util.ILocalPlayer;
import us.amon.stormward.worldgen.biome.StormwardBiomes;

public class Highstorm {
    public static final ResourceLocation RESOURCE = new ResourceLocation("stormward", "textures/environment/highstorm.png");
    public static final float SHEAR = 4.0f;
    public static final Vec3 WIND = new Vec3((double)-0.02f, 0.0, 0.0);
    public static final int CREM_CHANCE = 1000;
    public static final int LIGHTNING_CHANCE = 10000;
    public static final float PERCENT_SPEED = 0.02f;
    private static final int FOG_NEAR_PLANE = 24;
    private static final int FOG_FAR_PLANE = 48;
    private static final float FOG_COLOR_RED = 0.082f;
    private static final float FOG_COLOR_GREEN = 0.082f;
    private static final float FOG_COLOR_BLUE = 0.118f;

    public static boolean isBlockInHighstorm(Level pLevel, BlockPos pPos) {
        return pLevel.m_46471_() && StormwardBiomes.isBlockInRosharanBiome(pLevel, pPos);
    }

    public static boolean isEntityInHighstorm(Entity entity) {
        return Highstorm.isBlockInHighstorm(entity.m_9236_(), entity.m_20183_());
    }

    public static boolean isBlockExposed(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.m_6924_(Heightmap.Types.MOTION_BLOCKING, pPos.m_123341_(), pPos.m_123343_()) <= pPos.m_123342_() + 1;
    }

    public static boolean isBlockExposedToHighstorm(Level pLevel, BlockPos pPos) {
        return Highstorm.isBlockInHighstorm(pLevel, pPos) && Highstorm.isBlockExposed((LevelAccessor)pLevel, pPos);
    }

    public static boolean isEntityExposedToHighstorm(Entity entity) {
        return Highstorm.isBlockExposedToHighstorm(entity.m_9236_(), BlockPos.m_274446_((Position)entity.m_146892_()));
    }

    public static void onLivingEntityTick(LivingEntity entity) {
        if (entity instanceof Mob && !entity.m_9236_().m_5776_() && Highstorm.isEntityExposedToHighstorm((Entity)entity)) {
            entity.m_246865_(WIND);
            Highstorm.tickHighstormDamage(entity);
        }
    }

    public static void onPlayerTick(Player player, TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.START && !player.m_150110_().f_35934_ && Highstorm.isEntityExposedToHighstorm((Entity)player)) {
            if (player.m_9236_().m_5776_()) {
                player.m_246865_(WIND);
            } else {
                Highstorm.tickHighstormDamage((LivingEntity)player);
            }
        }
    }

    private static void tickHighstormDamage(LivingEntity entity) {
        if (entity.m_217043_().m_188503_(20) == 0) {
            DamageSource source = StormwardDamageSources.highstorm(entity.m_9236_());
            entity.m_6469_(source, ((Double)Config.HIGHSTORM_DAMAGE.get()).floatValue());
        }
    }

    public static void onComputeFogColor(ViewportEvent.ComputeFogColor event) {
        ILocalPlayer localPlayer;
        float highstormPercent;
        LocalPlayer localPlayer2 = Minecraft.m_91087_().f_91074_;
        if (localPlayer2 instanceof ILocalPlayer && (highstormPercent = (localPlayer = (ILocalPlayer)localPlayer2).stormward$getHighstormPercent()) > 0.0f) {
            event.setRed(Mth.m_14179_((float)highstormPercent, (float)event.getRed(), (float)0.082f));
            event.setGreen(Mth.m_14179_((float)highstormPercent, (float)event.getGreen(), (float)0.082f));
            event.setBlue(Mth.m_14179_((float)highstormPercent, (float)event.getBlue(), (float)0.118f));
        }
    }

    public static void onRenderFog(ViewportEvent.RenderFog event) {
        ILocalPlayer localPlayer;
        float highstormPercent;
        LocalPlayer localPlayer2 = Minecraft.m_91087_().f_91074_;
        if (localPlayer2 instanceof ILocalPlayer && (highstormPercent = (localPlayer = (ILocalPlayer)localPlayer2).stormward$getHighstormPercent()) > 0.0f) {
            event.setNearPlaneDistance(Mth.m_14179_((float)highstormPercent, (float)event.getNearPlaneDistance(), (float)24.0f));
            event.setFarPlaneDistance(Mth.m_14179_((float)highstormPercent, (float)event.getFarPlaneDistance(), (float)48.0f));
            event.setCanceled(true);
        }
    }
}

