/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.biome;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.StormwardMobCategories;
import us.amon.stormward.tag.StormwardBiomeTags;
import us.amon.stormward.worldgen.biome.StormwardPlacedFeatures;
import us.amon.stormward.worldgen.biome.carvers.StormwardConfiguredCarvers;

public class StormwardBiomes
extends OverworldBiomes {
    public static final ResourceKey<Biome> SHATTERED_PLAINS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "shattered_plains"));
    public static final ResourceKey<Biome> POLYP_FIELDS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "polyp_fields"));
    public static final ResourceKey<Biome> PURELAKE = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "purelake"));
    public static final ResourceKey<Biome> KHOLINAR = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "kholinar"));
    public static final ResourceKey<Biome> ROSHAR_OCEAN = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "roshar_ocean"));
    public static final ResourceKey<Biome> AIMIA = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "aimia"));
    public static final ResourceKey<Biome> FROSTLANDS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "frostlands"));
    public static final ResourceKey<Biome> HORNEATER_PEAKS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "horneater_peaks"));
    public static final ResourceKey<Biome> FRACTAL_FIELDS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "fractal_fields"));
    public static final ResourceKey<Biome> CRYSTAL_PLAINS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "crystal_plains"));
    public static final ResourceKey<Biome> CRYSTAL_FOREST = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "crystal_forest"));
    public static final ResourceKey<Biome> SHADESMAR_OCEAN = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("stormward", "shadesmar_ocean"));

    public static boolean isRosharanBiome(Holder<Biome> biome) {
        return biome.m_203656_(StormwardBiomeTags.ROSHARAN);
    }

    public static boolean isBlockInRosharanBiome(Level pLevel, BlockPos pPos) {
        Holder biome = pLevel.m_204166_(pPos);
        return StormwardBiomes.isRosharanBiome((Holder<Biome>)biome);
    }

    public static boolean isEntityInRosharanBiome(Entity entity) {
        return StormwardBiomes.isBlockInRosharanBiome(entity.m_9236_(), entity.m_20183_());
    }

    public static void bootstrap(BootstapContext<Biome> context) {
        context.m_255272_(SHATTERED_PLAINS, (Object)StormwardBiomes.shatteredPlains(context));
        context.m_255272_(POLYP_FIELDS, (Object)StormwardBiomes.polypFields(context));
        context.m_255272_(PURELAKE, (Object)StormwardBiomes.purelake(context));
        context.m_255272_(KHOLINAR, (Object)StormwardBiomes.kholinar(context));
        context.m_255272_(ROSHAR_OCEAN, (Object)StormwardBiomes.rosharOcean(context));
        context.m_255272_(AIMIA, (Object)StormwardBiomes.aimia(context));
        context.m_255272_(FROSTLANDS, (Object)StormwardBiomes.frostlands(context));
        context.m_255272_(HORNEATER_PEAKS, (Object)StormwardBiomes.horneaterPeaks(context));
        context.m_255272_(FRACTAL_FIELDS, (Object)StormwardBiomes.fractalFields(context));
        context.m_255272_(CRYSTAL_PLAINS, (Object)StormwardBiomes.crystalPlains(context));
        context.m_255272_(CRYSTAL_FOREST, (Object)StormwardBiomes.crystalForest(context));
        context.m_255272_(SHADESMAR_OCEAN, (Object)StormwardBiomes.shadesmarOcean(context));
    }

    private static void m_194869_(BiomeGenerationSettings.Builder pGenerationSettings) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)pGenerationSettings);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)pGenerationSettings);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)pGenerationSettings);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)pGenerationSettings);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)pGenerationSettings);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)pGenerationSettings);
        pGenerationSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, StormwardPlacedFeatures.SMALL_GREATSHELL_FOSSIL);
        pGenerationSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, StormwardPlacedFeatures.MEDIUM_GREATSHELL_FOSSIL);
        pGenerationSettings.m_255155_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, StormwardPlacedFeatures.LARGE_GREATSHELL_FOSSIL);
    }

    private static void commonRosharanSpawns(MobSpawnSettings.Builder pBuilder) {
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)pBuilder);
        pBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 100, 4, 4));
        pBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 100, 4, 4));
        pBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 100, 4, 4));
        pBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.CREMLING.get(), 4, 4, 4));
    }

    public static void addRosharanSoftDisks(BiomeGenerationSettings.Builder pBuilder) {
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.ROSHARAN_DISK_SAND);
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.ROSHARAN_DISK_CLAY);
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.ROSHARAN_DISK_GRAVEL);
    }

    private static void commonRosharanPlants(BiomeGenerationSettings.Builder pBuilder) {
        pBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195221_);
        pBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.YELLOW_SHALEBARK_PATCH);
        pBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.ORANGE_SHALEBARK_PATCH);
        pBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.RED_SHALEBARK_PATCH);
        pBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.PINK_SHALEBARK_PATCH);
        pBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.BLUE_SHALEBARK_PATCH);
    }

    private static Biome shatteredPlains(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.WARFORM_LISTENER.get(), 90, 2, 6));
        StormwardBiomes.commonRosharanSpawns(spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        StormwardBiomes.m_194869_(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        StormwardBiomes.commonRosharanPlants(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.ROCKBUD);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.STONE_GRASS_PATCH_SHATTERED_PLAINS);
        return StormwardBiomes.rosharanBiome(1.5f, 0.2f, spawnBuilder, biomeBuilder, null);
    }

    private static Biome polypFields(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.CHULL.get(), 12, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.AXEHOUND.get(), 8, 4, 4));
        StormwardBiomes.commonRosharanSpawns(spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        StormwardBiomes.m_194869_(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        StormwardBiomes.addRosharanSoftDisks(biomeBuilder);
        StormwardBiomes.commonRosharanPlants(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.ROCKBUD);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.STONE_GRASS_PATCH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.TALL_STONE_GRASS_PATCH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.PATCH_LAVIS_POLYP);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.SNARLBRUSH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.TREES_POLYP_FIELDS);
        return StormwardBiomes.rosharanBiome(0.7f, 0.8f, spawnBuilder, biomeBuilder, null);
    }

    private static Biome purelake(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 25, 8, 8));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.CHULL.get(), 12, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.AXEHOUND.get(), 8, 4, 4));
        StormwardBiomes.commonRosharanSpawns(spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        StormwardBiomes.m_194869_(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.LAKES, StormwardPlacedFeatures.PURELAKE);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        StormwardBiomes.addRosharanSoftDisks(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195466_);
        StormwardBiomes.commonRosharanPlants(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.ROCKBUD);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.STONE_GRASS_PATCH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.TALL_STONE_GRASS_PATCH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.TREES_PURELAKE);
        return StormwardBiomes.biome(true, 1.2f, 0.9f, 4566514, 267827, 10531813, null, null, spawnBuilder, biomeBuilder, null);
    }

    private static Biome kholinar(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.CHULL.get(), 12, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.AXEHOUND.get(), 8, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.WHITESPINE.get(), 20, 4, 4));
        StormwardBiomes.commonRosharanSpawns(spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        StormwardBiomes.m_194869_(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        StormwardBiomes.addRosharanSoftDisks(biomeBuilder);
        StormwardBiomes.commonRosharanPlants(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.ROCKBUD);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.STONE_GRASS_PATCH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.TALL_STONE_GRASS_PATCH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.TREES_KHOLINAR);
        return StormwardBiomes.rosharanBiome(0.6f, 0.4f, spawnBuilder, biomeBuilder, null);
    }

    private static Biome rosharOcean(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 1, 1, 4));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20556_, 10, 3, 6));
        StormwardBiomes.commonRosharanSpawns(spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20562_, 5, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        StormwardBiomes.m_194869_(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195401_);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195224_);
        BiomeDefaultFeatures.m_126761_((BiomeGenerationSettings.Builder)biomeBuilder);
        StormwardBiomes.commonRosharanPlants(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.STONE_GRASS_PATCH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.TALL_STONE_GRASS_PATCH);
        return StormwardBiomes.rosharanBiome(0.5f, 0.5f, spawnBuilder, biomeBuilder, null);
    }

    private static Biome aimia(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.CHULL.get(), 12, 4, 4));
        StormwardBiomes.commonRosharanSpawns(spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        StormwardBiomes.m_194869_(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        StormwardBiomes.addRosharanSoftDisks(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, StormwardPlacedFeatures.SMALL_GREATSHELL_FOSSIL_AIMIA);
        biomeBuilder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, StormwardPlacedFeatures.MEDIUM_GREATSHELL_FOSSIL_AIMIA);
        biomeBuilder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, StormwardPlacedFeatures.LARGE_GREATSHELL_FOSSIL_AIMIA);
        StormwardBiomes.commonRosharanPlants(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.ROCKBUD);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.STONE_GRASS_PATCH_AIMIA);
        return StormwardBiomes.rosharanBiome(0.2f, 0.4f, spawnBuilder, biomeBuilder, null);
    }

    private static Biome frostlands(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        StormwardBiomes.commonRosharanSpawns(spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.CHULL.get(), 12, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.WHITESPINE.get(), 20, 4, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, StormwardPlacedFeatures.ROSHAR_FREEZE_LAYER);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        StormwardBiomes.addRosharanSoftDisks(biomeBuilder);
        StormwardBiomes.commonRosharanPlants(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.STONE_GRASS_PATCH_FROSTLANDS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.TREES_FROSTLANDS);
        return StormwardBiomes.rosharanBiome(-0.2f, 1.2f, spawnBuilder, biomeBuilder, null);
    }

    private static Biome horneaterPeaks(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        StormwardBiomes.commonRosharanSpawns(spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, StormwardPlacedFeatures.ROSHAR_FREEZE_LAYER);
        biomeBuilder.m_255155_(GenerationStep.Decoration.LAKES, StormwardPlacedFeatures.HOTSPRING);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        StormwardBiomes.addRosharanSoftDisks(biomeBuilder);
        StormwardBiomes.commonRosharanPlants(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.STONE_GRASS_PATCH_HORNEATER_PEAKS);
        return StormwardBiomes.biome(true, -0.7f, 1.8f, 4566514, 267827, 10531813, null, null, spawnBuilder, biomeBuilder, null);
    }

    private static void commonShadesmarSpawns(MobSpawnSettings.Builder pBuilder) {
        pBuilder.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.COGNITIVE_FLAME.get(), 15, 1, 8));
        pBuilder.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.ANTICIPATIONSPREN_SHADESMAR.get(), 35, 2, 5));
        pBuilder.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.LIFESPREN_SHADESMAR.get(), 25, 2, 5));
        pBuilder.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.FEARSPREN_SHADESMAR.get(), 25, 2, 5));
        pBuilder.m_48376_(StormwardMobCategories.SHADESMAR_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)StormwardEntities.ANGERSPREN_SHADESMAR.get(), 60, 2, 5));
        pBuilder.m_48376_(StormwardMobCategories.SHADESMAR_MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 20, 1, 1));
        pBuilder.m_48376_(StormwardMobCategories.SHADESMAR_MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 20, 1, 1));
    }

    private static void addShadesmarOres(BiomeGenerationSettings.Builder pBuilder) {
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.SHADESMAR_SMOKESTONE_ORE);
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.SHADESMAR_TOPAZ_ORE);
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.SHADESMAR_GARNET_ORE);
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.SHADESMAR_RUBY_ORE);
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.SHADESMAR_AMETHYST_ORE);
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.SHADESMAR_SAPPHIRE_ORE);
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.SHADESMAR_ZIRCON_ORE);
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.SHADESMAR_DIAMOND_ORE);
        pBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, StormwardPlacedFeatures.SHADESMAR_EMERALD_ORE);
    }

    private static Biome fractalFields(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        StormwardBiomes.commonShadesmarSpawns(spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CAVE);
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CAVE_EXTRA);
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CANYON);
        StormwardBiomes.addShadesmarOres(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.FRACTAL_FERN_PATCH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.LARGE_FRACTAL_FERN_PATCH);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.CRYSTAL_SPINES);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.FRACTAL_MASSES);
        return StormwardBiomes.m_264144_(false, 0.5f, 0.0f, spawnBuilder, biomeBuilder, null);
    }

    private static Biome crystalPlains(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        StormwardBiomes.commonShadesmarSpawns(spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CAVE);
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CAVE_EXTRA);
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CANYON);
        StormwardBiomes.addShadesmarOres(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.FRACTAL_FERNS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.CRYSTAL_FRONDS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.CRYSTAL_SPINES);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.CRYSTAL_PILLARS);
        return StormwardBiomes.m_264144_(false, 0.5f, 0.0f, spawnBuilder, biomeBuilder, null);
    }

    private static Biome crystalForest(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        StormwardBiomes.commonShadesmarSpawns(spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CAVE);
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CAVE_EXTRA);
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CANYON);
        StormwardBiomes.addShadesmarOres(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.CRYSTAL_SPROUTS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.CRYSTAL_SPINES);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.TALL_CRYSTAL_PILLARS);
        return StormwardBiomes.m_264144_(false, 0.5f, 0.0f, spawnBuilder, biomeBuilder, null);
    }

    private static Biome shadesmarOcean(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        StormwardBiomes.commonShadesmarSpawns(spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CAVE);
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CAVE_EXTRA);
        biomeBuilder.m_255308_(GenerationStep.Carving.AIR, StormwardConfiguredCarvers.SHADESMAR_CANYON);
        StormwardBiomes.addShadesmarOres(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.FRACTAL_FERNS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, StormwardPlacedFeatures.CRYSTAL_SPINES);
        return StormwardBiomes.m_264144_(false, 0.5f, 0.0f, spawnBuilder, biomeBuilder, null);
    }

    private static Biome rosharanBiome(float pTemperature, float pDownfall, MobSpawnSettings.Builder pMobSpawnSettings, BiomeGenerationSettings.Builder pGenerationSettings, @Nullable Music pBackgroundMusic) {
        return StormwardBiomes.biome(true, pTemperature, pDownfall, 4936036, 921108, 10531813, null, null, pMobSpawnSettings, pGenerationSettings, pBackgroundMusic);
    }

    private static Biome m_264144_(boolean pHasPercipitation, float pTemperature, float pDownfall, MobSpawnSettings.Builder pMobSpawnSettings, BiomeGenerationSettings.Builder pGenerationSettings, @Nullable Music pBackgroundMusic) {
        return StormwardBiomes.m_271953_(pHasPercipitation, pTemperature, pDownfall, 4159204, 329011, null, null, pMobSpawnSettings, pGenerationSettings, pBackgroundMusic);
    }

    private static Biome m_271953_(boolean pHasPrecipitation, float pTemperature, float pDownfall, int pWaterColor, int pWaterFogColor, @Nullable Integer pGrassColorOverride, @Nullable Integer pFoliageColorOverride, MobSpawnSettings.Builder pMobSpawnSettings, BiomeGenerationSettings.Builder pGenerationSettings, @Nullable Music pBackgroundMusic) {
        return StormwardBiomes.biome(pHasPrecipitation, pTemperature, pDownfall, pWaterColor, pWaterFogColor, StormwardBiomes.m_194843_((float)pTemperature), pGrassColorOverride, pFoliageColorOverride, pMobSpawnSettings, pGenerationSettings, pBackgroundMusic);
    }

    private static Biome biome(boolean pHasPrecipitation, float pTemperature, float pDownfall, int pWaterColor, int pWaterFogColor, int pSkyColor, @Nullable Integer pGrassColorOverride, @Nullable Integer pFoliageColorOverride, MobSpawnSettings.Builder pMobSpawnSettings, BiomeGenerationSettings.Builder pGenerationSettings, @Nullable Music pBackgroundMusic) {
        BiomeSpecialEffects.Builder biomespecialeffects$builder = new BiomeSpecialEffects.Builder().m_48034_(pWaterColor).m_48037_(pWaterFogColor).m_48019_(12638463).m_48040_(pSkyColor).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(pBackgroundMusic);
        if (pGrassColorOverride != null) {
            biomespecialeffects$builder.m_48045_(pGrassColorOverride.intValue());
        }
        if (pFoliageColorOverride != null) {
            biomespecialeffects$builder.m_48043_(pFoliageColorOverride.intValue());
        }
        return new Biome.BiomeBuilder().m_264558_(pHasPrecipitation).m_47609_(pTemperature).m_47611_(pDownfall).m_47603_(biomespecialeffects$builder.m_48018_()).m_47605_(pMobSpawnSettings.m_48381_()).m_47601_(pGenerationSettings.m_255380_()).m_47592_();
    }
}

