/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.dimension;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.OptionalLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import terrablender.api.ParameterUtils;
import us.amon.stormward.worldgen.biome.StormwardBiomes;
import us.amon.stormward.worldgen.dimension.StormwardDimensionEffects;
import us.amon.stormward.worldgen.dimension.StormwardNoiseGeneratorSettings;

public class StormwardDimensions {
    public static final ResourceKey<LevelStem> SHADESMAR_LEVEL_STEM = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)new ResourceLocation("stormward", "shadesmar"));
    public static final ResourceKey<Level> SHADESMAR_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("stormward", "shadesmar"));
    public static final ResourceKey<DimensionType> SHADESMAR_DIMENSION_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("stormward", "shadesmar"));

    public static void bootstrapType(BootstapContext<DimensionType> context) {
        context.m_255272_(SHADESMAR_DIMENSION_TYPE, (Object)new DimensionType(OptionalLong.of(0L), false, false, false, false, 1.0, false, false, 0, 192, 192, BlockTags.f_13058_, StormwardDimensionEffects.SHADESMAR, 0.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 0)));
    }

    public static void bootstrapStem(BootstapContext<LevelStem> context) {
        HolderGetter biomeRegistry = context.m_255420_(Registries.f_256952_);
        HolderGetter noiseGenSettings = context.m_255420_(Registries.f_256932_);
        HolderGetter dimensionTypes = context.m_255420_(Registries.f_256787_);
        ArrayList points = new ArrayList();
        new ParameterUtils.ParameterPointListBuilder().temperature(new ParameterUtils.Temperature[]{ParameterUtils.Temperature.FULL_RANGE}).humidity(new ParameterUtils.Humidity[]{ParameterUtils.Humidity.FULL_RANGE}).continentalness(new ParameterUtils.Continentalness[]{ParameterUtils.Continentalness.INLAND, ParameterUtils.Continentalness.MUSHROOM_FIELDS}).erosion(new ParameterUtils.Erosion[]{ParameterUtils.Erosion.FULL_RANGE}).depth(new ParameterUtils.Depth[]{ParameterUtils.Depth.FULL_RANGE}).weirdness(new ParameterUtils.Weirdness[]{ParameterUtils.Weirdness.FULL_RANGE}).build().forEach(point -> points.add(new Pair(point, (Object)biomeRegistry.m_255043_(StormwardBiomes.SHADESMAR_OCEAN))));
        new ParameterUtils.ParameterPointListBuilder().temperature(new ParameterUtils.Temperature[]{ParameterUtils.Temperature.ICY}).humidity(new ParameterUtils.Humidity[]{ParameterUtils.Humidity.DRY}).continentalness(new ParameterUtils.Continentalness[]{ParameterUtils.Continentalness.DEEP_OCEAN, ParameterUtils.Continentalness.OCEAN, ParameterUtils.Continentalness.COAST}).erosion(new ParameterUtils.Erosion[]{ParameterUtils.Erosion.FULL_RANGE}).depth(new ParameterUtils.Depth[]{ParameterUtils.Depth.FULL_RANGE}).weirdness(new ParameterUtils.Weirdness[]{ParameterUtils.Weirdness.FULL_RANGE}).build().forEach(point -> points.add(new Pair(point, (Object)biomeRegistry.m_255043_(StormwardBiomes.FRACTAL_FIELDS))));
        new ParameterUtils.ParameterPointListBuilder().temperature(new ParameterUtils.Temperature[]{ParameterUtils.Temperature.NEUTRAL}).humidity(new ParameterUtils.Humidity[]{ParameterUtils.Humidity.NEUTRAL}).continentalness(new ParameterUtils.Continentalness[]{ParameterUtils.Continentalness.DEEP_OCEAN, ParameterUtils.Continentalness.OCEAN, ParameterUtils.Continentalness.COAST}).erosion(new ParameterUtils.Erosion[]{ParameterUtils.Erosion.FULL_RANGE}).depth(new ParameterUtils.Depth[]{ParameterUtils.Depth.FULL_RANGE}).weirdness(new ParameterUtils.Weirdness[]{ParameterUtils.Weirdness.FULL_RANGE}).build().forEach(point -> points.add(new Pair(point, (Object)biomeRegistry.m_255043_(StormwardBiomes.CRYSTAL_PLAINS))));
        new ParameterUtils.ParameterPointListBuilder().temperature(new ParameterUtils.Temperature[]{ParameterUtils.Temperature.HOT}).humidity(new ParameterUtils.Humidity[]{ParameterUtils.Humidity.HUMID}).continentalness(new ParameterUtils.Continentalness[]{ParameterUtils.Continentalness.DEEP_OCEAN, ParameterUtils.Continentalness.OCEAN, ParameterUtils.Continentalness.COAST}).erosion(new ParameterUtils.Erosion[]{ParameterUtils.Erosion.FULL_RANGE}).depth(new ParameterUtils.Depth[]{ParameterUtils.Depth.FULL_RANGE}).weirdness(new ParameterUtils.Weirdness[]{ParameterUtils.Weirdness.FULL_RANGE}).build().forEach(point -> points.add(new Pair(point, (Object)biomeRegistry.m_255043_(StormwardBiomes.CRYSTAL_FOREST))));
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList(points));
        NoiseBasedChunkGenerator chunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)biomeSource, (Holder)noiseGenSettings.m_255043_(StormwardNoiseGeneratorSettings.SHADESMAR));
        LevelStem stem = new LevelStem((Holder)dimensionTypes.m_255043_(SHADESMAR_DIMENSION_TYPE), (ChunkGenerator)chunkGenerator);
        context.m_255272_(SHADESMAR_LEVEL_STEM, (Object)stem);
    }

    public static BlockPos overworldToShadesmar(BlockPos pOverworldPos) {
        return new BlockPos(pOverworldPos.m_123341_(), 62 + Mth.m_14167_((float)((float)(pOverworldPos.m_123342_() - 62) / 2.0f)), pOverworldPos.m_123343_());
    }

    public static BlockPos shadesmarToOverworld(BlockPos pShadesmarPos) {
        return new BlockPos(pShadesmarPos.m_123341_(), 62 + (pShadesmarPos.m_123342_() - 62) * 2, pShadesmarPos.m_123343_());
    }

    public static BlockPos convert(BlockPos pPos, ResourceKey<Level> pDestination) {
        if (pDestination == SHADESMAR_DIMENSION) {
            return StormwardDimensions.overworldToShadesmar(pPos);
        }
        if (pDestination == Level.f_46428_) {
            return StormwardDimensions.shadesmarToOverworld(pPos);
        }
        return pPos;
    }
}

