/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.feature;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.worldgen.configuration.FractalMassConfiguration;

public class FractalMassFeature
extends Feature<FractalMassConfiguration> {
    public FractalMassFeature(Codec<FractalMassConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<FractalMassConfiguration> pContext) {
        WorldGenLevel level = pContext.m_159774_();
        BlockPos origin = pContext.m_159777_();
        RandomSource random = pContext.m_225041_();
        FractalMassConfiguration config = (FractalMassConfiguration)pContext.m_159778_();
        HashSet plotted = Sets.newHashSet();
        HashMap blocks = Maps.newHashMap();
        int height = config.heightProvider.m_214085_(random);
        float radius = Math.max(1.5f, (float)height / 4.0f);
        BlockPos center = origin.m_6630_(height);
        double scale = (double)height / (Math.PI * 2);
        Direction.Axis axis = random.m_188499_() ? Direction.Axis.X : Direction.Axis.Z;
        Direction forward = axis == Direction.Axis.X ? Direction.WEST : Direction.NORTH;
        Direction.Axis perpendicular = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        int iterations = height * 8;
        double xFrac = random.m_188500_();
        double yFrac = random.m_188500_();
        for (int i = 0; i < iterations; ++i) {
            boolean stripe;
            double percent = (double)i / (double)iterations;
            double t = Math.PI * 2 * percent;
            double x = scale * t * Math.cos(t) + xFrac;
            double y = scale * t * Math.sin(t) + yFrac;
            BlockPos pos = center.m_5484_(Direction.DOWN, (int)x).m_5484_(forward, (int)y);
            boolean bl = stripe = Mth.m_14107_((double)(scale * t * (1.0 - percent) * 12.0)) % 6 == 0;
            if (plotted.contains(pos) && !stripe) continue;
            plotted.add(pos);
            this.placeBlock(pos, (double)radius * percent, blocks, stripe);
        }
        if (blocks.isEmpty()) {
            return false;
        }
        int perpendicularPos = origin.m_123304_(perpendicular);
        int xOffset = random.m_216332_(0, 2);
        int yOffset = random.m_216332_(0, 2);
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            level.m_7731_(pos, ((Boolean)entry.getValue() != false ? config.ringProvider : config.baseProvider).m_213972_(random, pos), 19);
            if (pos.m_123304_(perpendicular) != perpendicularPos) continue;
            if ((pos.m_123304_(axis) + xOffset) % 3 == 0) {
                this.placeEnd(pos, Direction.UP, random, level, blocks, config.endsProvider);
                if (pos.m_123342_() > origin.m_123342_()) {
                    this.placeEnd(pos, Direction.DOWN, random, level, blocks, config.endsProvider);
                }
            }
            if ((pos.m_123342_() + yOffset) % 3 != 0) continue;
            this.placeEnd(pos, forward, random, level, blocks, config.endsProvider);
            this.placeEnd(pos, forward.m_122424_(), random, level, blocks, config.endsProvider);
        }
        return true;
    }

    protected void placeEnd(BlockPos pPos, Direction pDirection, RandomSource pRandom, WorldGenLevel pLevel, Map<BlockPos, Boolean> pBlocks, BlockStateProvider pProvider) {
        BlockPos endPos = pPos.m_121945_(pDirection);
        if (pRandom.m_188500_() <= 0.75 && !pBlocks.containsKey(endPos)) {
            pLevel.m_7731_(endPos, (BlockState)pProvider.m_213972_(pRandom, endPos).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)pDirection), 19);
        }
    }

    protected void placeBlock(BlockPos pPos, double pRadius, Map<BlockPos, Boolean> pBlocks, boolean pRing) {
        if (pRadius < 0.0) {
            return;
        }
        pBlocks.put(pPos, pRing);
        for (Direction direction : Direction.values()) {
            this.placeBlock(pPos.m_121945_(direction), pRadius - 1.0, pBlocks, pRing);
        }
    }
}

