/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.worldgen.PerpendicularityBlock;

public class HotSpringFeature
extends Feature<Configuration> {
    protected static final Direction[] EDGE_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN};

    public HotSpringFeature(Codec<Configuration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<Configuration> pContext) {
        BlockPos origin = pContext.m_159777_();
        WorldGenLevel level = pContext.m_159774_();
        RandomSource random = pContext.m_225041_();
        Configuration configuration = (Configuration)pContext.m_159778_();
        int radiusX = configuration.radius().m_214085_(random);
        int radiusY = configuration.depth().m_214085_(random);
        int radiusZ = configuration.radius().m_214085_(random);
        Set<Vec3i> shape = HotSpringFeature.getLakeShape(radiusX / 4, radiusX, radiusX / 4, radiusX, radiusY / 4, radiusY, radiusY / 8, radiusY / 2, radiusZ / 4, radiusZ, radiusZ / 4, radiusZ, 2.5, random);
        int y = origin.m_123342_();
        int depth = 0;
        for (Vec3i offset : shape) {
            if (offset.m_123342_() == 0) {
                y = Math.min(y, level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, origin.m_123341_() + offset.m_123341_(), origin.m_123343_() + offset.m_123343_()));
                continue;
            }
            depth = Math.min(depth, offset.m_123342_());
        }
        if (origin.m_123342_() - y > 12) {
            y = origin.m_123342_() - 12;
        }
        origin = origin.m_175288_(y);
        boolean hasPerpendicularity = random.m_188501_() <= configuration.perpendicularityChance();
        int perpendicularity = Mth.m_14143_((float)((float)depth * 0.7f));
        for (Vec3i offset : shape) {
            BlockPos pos = origin.m_121955_(offset);
            BlockState state = offset.m_123342_() > 0 ? Blocks.f_50016_.m_49966_() : (HotSpringFeature.isEdge(shape, offset) ? (offset.m_123342_() == 0 ? configuration.bank().m_213972_(random, pos) : configuration.edge().m_213972_(random, pos)) : (hasPerpendicularity && offset.m_123342_() == perpendicularity ? (BlockState)((PerpendicularityBlock)((Object)StormwardBlocks.PERPENDICULARITY.get())).m_49966_().m_61124_((Property)PerpendicularityBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : Blocks.f_49990_.m_49966_()));
            this.safeReplaceBlock(level, pos, state);
        }
        return true;
    }

    public static boolean isEdge(Set<Vec3i> pShape, Vec3i pPos) {
        for (Direction direction : Direction.values()) {
            if (pShape.contains(pPos.m_121945_(direction))) continue;
            return true;
        }
        return false;
    }

    public static Set<Vec3i> getLakeShape(int pMinNegX, int pMaxNegX, int pMinPosX, int pMaxPosX, int pMinNegY, int pMaxNegY, int pMinPosY, int pMaxPosY, int pMinNegZ, int pMaxNegZ, int pMinPosZ, int pMaxPosZ, double pExpansion, RandomSource pRandom) {
        int expansion = Mth.m_14107_((double)pExpansion);
        int minNegX = Math.max(0, pMinNegX - expansion);
        int maxNegX = Math.max(0, pMaxNegX - expansion);
        int minPosX = Math.max(0, pMinPosX - expansion);
        int maxPosX = Math.max(0, pMaxPosX - expansion);
        int minNegY = Math.max(0, pMinNegY - expansion);
        int maxNegY = Math.max(0, pMaxNegY - expansion);
        int minPosY = Math.max(0, pMinPosY - expansion);
        int maxPosY = Math.max(0, pMaxPosY - expansion);
        int minNegZ = Math.max(0, pMinNegZ - expansion);
        int maxNegZ = Math.max(0, pMaxNegZ - expansion);
        int minPosZ = Math.max(0, pMinPosZ - expansion);
        int maxPosZ = Math.max(0, pMaxPosZ - expansion);
        HashSet<Vec3i> shape = new HashSet<Vec3i>();
        ArrayDeque<Vec3i> queue = new ArrayDeque<Vec3i>();
        for (int x = -minNegX; x <= minPosX; ++x) {
            for (int y = -minNegY; y <= minPosY; ++y) {
                for (int z = -minNegZ; z <= minPosZ; ++z) {
                    Vec3i pos = new Vec3i(x, y, z);
                    shape.add(pos);
                    if (x != -minNegX && x != minPosX && y != -minNegY && y != minPosY && z != -minNegZ && z != minPosZ) continue;
                    queue.add(pos);
                }
            }
        }
        while (!queue.isEmpty()) {
            Vec3i pos = (Vec3i)queue.remove();
            for (Direction direction : Direction.values()) {
                Vec3i relative = pos.m_121945_(direction);
                if (shape.contains(relative)) continue;
                double threshold = 0.0;
                threshold += relative.m_123341_() > 0 ? Math.max(0.0, (double)(Math.abs(relative.m_123341_()) - minPosX)) / (double)(maxPosX - minPosX) : Math.max(0.0, (double)(Math.abs(relative.m_123341_()) - minNegX)) / (double)(maxNegX - minNegX);
                threshold += relative.m_123342_() > 0 ? Math.max(0.0, (double)(Math.abs(relative.m_123342_()) - minPosY)) / (double)(maxPosY - minPosY) : Math.max(0.0, (double)(Math.abs(relative.m_123342_()) - minNegY)) / (double)(maxNegY - minNegY);
                threshold += relative.m_123343_() > 0 ? Math.max(0.0, (double)(Math.abs(relative.m_123343_()) - minPosZ)) / (double)(maxPosZ - minPosZ) : Math.max(0.0, (double)(Math.abs(relative.m_123343_()) - minNegZ)) / (double)(maxNegZ - minNegZ);
                if (!(pRandom.m_188500_() > threshold)) continue;
                shape.add(relative);
                queue.add(relative);
            }
        }
        HashSet<Vec3i> edges = new HashSet<Vec3i>();
        for (Vec3i pos : shape) {
            if (pos.m_123341_() > -minNegX && pos.m_123341_() < minPosX && pos.m_123342_() > -minNegY && pos.m_123342_() < minPosY && pos.m_123343_() > -minNegZ && pos.m_123343_() < minPosZ) continue;
            int adjacent = 0;
            for (Direction direction : Direction.values()) {
                if (!shape.contains(pos.m_121945_(direction))) continue;
                ++adjacent;
            }
            if (adjacent >= 6) continue;
            edges.add(pos);
        }
        int steps = Mth.m_14165_((double)pExpansion);
        for (Vec3i pos : edges) {
            for (int i = -steps; i <= steps; ++i) {
                for (int y = -steps; y <= steps; ++y) {
                    for (int z = -steps; z <= steps; ++z) {
                        if (!((double)(i * i + y * y + z * z) <= pExpansion * pExpansion * pExpansion)) continue;
                        shape.add(pos.m_7918_(i, y, z));
                    }
                }
            }
        }
        return shape;
    }

    private void safeReplaceBlock(WorldGenLevel pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.m_8055_(pPos).m_204336_(BlockTags.f_144287_)) {
            pLevel.m_7731_(pPos, pState, 2);
            this.m_159739_(pLevel, pPos);
        }
    }

    public record Configuration(IntProvider radius, IntProvider depth, BlockStateProvider bank, BlockStateProvider edge, float perpendicularityChance) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.f_146531_.fieldOf("radius").forGetter(Configuration::radius), (App)IntProvider.f_146531_.fieldOf("depth").forGetter(Configuration::depth), (App)BlockStateProvider.f_68747_.fieldOf("bank").forGetter(Configuration::bank), (App)BlockStateProvider.f_68747_.fieldOf("edge").forGetter(Configuration::edge), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("perpendicularity_chance").forGetter(Configuration::perpendicularityChance)).apply((Applicative)instance, Configuration::new));
    }
}

