/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.worldgen.plant.IRosharanPlant;
import us.amon.stormward.block.worldgen.plant.PlantReaction;
import us.amon.stormward.tag.StormwardBlockTags;

public class PurelakeFeature
extends Feature<Configuration> {
    public PurelakeFeature(Codec<Configuration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<Configuration> pContext) {
        int lakeHeight;
        int height;
        BlockPos origin = pContext.m_159777_();
        WorldGenLevel level = pContext.m_159774_();
        RandomSource random = pContext.m_225041_();
        Configuration configuration = (Configuration)pContext.m_159778_();
        int border = 3;
        int radiusX = Math.max(1, configuration.radius().m_214085_(random) - border + 1);
        int radiusY = Math.max(1, configuration.radius().m_214085_(random) - border + 1);
        origin = origin.m_7918_(7, 0, 7);
        Set<Vec3i> shape = PurelakeFeature.getLakeShape(8, Math.max(radiusX, 8), 8, Math.max(radiusX, 8), 8, Math.max(radiusY, 8), 8, Math.max(radiusY, 8), 2.5, random);
        ArrayDeque<Vec3i> queue = new ArrayDeque<Vec3i>();
        HashMap<Vec3i, Integer> distances = new HashMap<Vec3i, Integer>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockState fluid = configuration.fluid().m_213972_(random, origin);
        for (Vec3i offset : shape) {
            if (PurelakeFeature.isEdge(shape, offset)) {
                queue.add(offset);
                distances.put(offset, 1);
                continue;
            }
            pos.m_175306_((Vec3i)origin, offset);
            height = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_());
            if (!this.adjustHeight(level, configuration, random, pos, height, lakeHeight = configuration.height().m_214085_(random), fluid)) continue;
            this.replaceBlock(level, (BlockPos)pos, fluid);
            if (height < lakeHeight) {
                this.replaceBlock(level, (BlockPos)pos.m_122178_(pos.m_123341_(), lakeHeight - 1, pos.m_123343_()), fluid);
            }
            this.replaceBlock(level, pos.m_7495_(), configuration.floor().m_213972_(random, pos.m_7495_()));
        }
        while (!queue.isEmpty()) {
            Vec3i offset = (Vec3i)queue.remove();
            int distance = (Integer)distances.get(offset);
            pos.m_175306_((Vec3i)origin, offset);
            height = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_());
            lakeHeight = Mth.m_269140_((float)(((float)distance - 1.0f) / (float)border), (int)configuration.height().m_214085_(random), (int)height);
            if (this.adjustHeight(level, configuration, random, pos, height, lakeHeight, fluid) && lakeHeight >= height && this.isWallNecessary(level, (BlockPos)pos)) {
                this.replaceBlock(level, (BlockPos)pos, distance == 1 ? configuration.bank().m_213972_(random, (BlockPos)pos) : configuration.wall().m_213972_(random, (BlockPos)pos));
            }
            if (distance >= border) continue;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vec3i relative = offset.m_121945_(direction);
                if (shape.contains(relative)) continue;
                if (!distances.containsKey(relative)) {
                    queue.add(relative);
                }
                distances.put(relative, Math.min(distances.getOrDefault(relative, Integer.MAX_VALUE), distance + 1));
            }
        }
        return true;
    }

    public static boolean isEdge(Set<Vec3i> pShape, Vec3i pPos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (pShape.contains(pPos.m_121945_(direction))) continue;
            return true;
        }
        return false;
    }

    public static Set<Vec3i> getLakeShape(int pMinNegX, int pMaxNegX, int pMinPosX, int pMaxPosX, int pMinNegZ, int pMaxNegZ, int pMinPosZ, int pMaxPosZ, double pExpansion, RandomSource pRandom) {
        int expansion = Mth.m_14107_((double)pExpansion);
        int minNegX = Math.max(0, pMinNegX - expansion);
        int maxNegX = Math.max(0, pMaxNegX - expansion);
        int minPosX = Math.max(0, pMinPosX - expansion);
        int maxPosX = Math.max(0, pMaxPosX - expansion);
        int minNegZ = Math.max(0, pMinNegZ - expansion);
        int maxNegZ = Math.max(0, pMaxNegZ - expansion);
        int minPosZ = Math.max(0, pMinPosZ - expansion);
        int maxPosZ = Math.max(0, pMaxPosZ - expansion);
        HashSet<Vec3i> shape = new HashSet<Vec3i>();
        ArrayDeque<Vec3i> queue = new ArrayDeque<Vec3i>();
        for (int x = -minNegX; x <= minPosX; ++x) {
            for (int z = -minNegZ; z <= minPosZ; ++z) {
                Vec3i pos = new Vec3i(x, 0, z);
                shape.add(pos);
                if (x != -minNegX && x != minPosX && z != -minNegZ && z != minPosZ) continue;
                queue.add(pos);
            }
        }
        while (!queue.isEmpty()) {
            Vec3i pos = (Vec3i)queue.remove();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vec3i relative = pos.m_121945_(direction);
                if (shape.contains(relative)) continue;
                double threshold = 0.0;
                threshold += relative.m_123341_() > 0 ? Math.max(0.0, (double)(Math.abs(relative.m_123341_()) - minPosX)) / (double)(maxPosX - minPosX) : Math.max(0.0, (double)(Math.abs(relative.m_123341_()) - minNegX)) / (double)(maxNegX - minNegX);
                threshold += relative.m_123343_() > 0 ? Math.max(0.0, (double)(Math.abs(relative.m_123343_()) - minPosZ)) / (double)(maxPosZ - minPosZ) : Math.max(0.0, (double)(Math.abs(relative.m_123343_()) - minNegZ)) / (double)(maxNegZ - minNegZ);
                if (!(pRandom.m_188500_() > threshold)) continue;
                shape.add(relative);
                queue.add(relative);
            }
        }
        HashSet<Vec3i> edges = new HashSet<Vec3i>();
        for (Vec3i pos : shape) {
            if (pos.m_123341_() > -minNegX && pos.m_123341_() < minPosX && pos.m_123343_() > -minNegZ && pos.m_123343_() < minPosZ) continue;
            int adjacent = 0;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!shape.contains(pos.m_121945_(direction))) continue;
                ++adjacent;
            }
            if (adjacent >= 4) continue;
            edges.add(pos);
        }
        int steps = Mth.m_14165_((double)pExpansion);
        for (Vec3i pos : edges) {
            for (int x = -steps; x <= steps; ++x) {
                for (int z = -steps; z <= steps; ++z) {
                    if (!((double)(x * x + z * z) <= pExpansion * pExpansion)) continue;
                    shape.add(pos.m_7918_(x, 0, z));
                }
            }
        }
        return shape;
    }

    private boolean adjustHeight(WorldGenLevel pLevel, Configuration pConfig, RandomSource pRandom, BlockPos.MutableBlockPos pPos, int pCurrentHeight, int pDesiredHeight, BlockState pFluid) {
        BlockState belowState;
        int y;
        if (pCurrentHeight > pDesiredHeight) {
            this.m_159739_(pLevel, (BlockPos)pPos.m_142448_(pCurrentHeight));
        } else {
            this.m_159739_(pLevel, (BlockPos)pPos.m_142448_(pDesiredHeight - 1));
        }
        for (y = pCurrentHeight; y > pDesiredHeight; --y) {
            if (this.replaceBlock(pLevel, (BlockPos)pPos.m_142448_(y), Blocks.f_50016_.m_49966_())) continue;
            return false;
        }
        if (pCurrentHeight > pDesiredHeight && (belowState = pLevel.m_8055_(pPos.m_7495_())).m_60713_((Block)StormwardBlocks.STONE_GRASS_BLOCK.get())) {
            pLevel.m_7731_(pPos.m_7495_(), (BlockState)belowState.m_61124_(IRosharanPlant.PLANT_REACTION, (Comparable)((Object)PlantReaction.EXTENDED)), 2);
        }
        for (y = pDesiredHeight - 1; y >= pCurrentHeight; --y) {
            boolean floor;
            pPos.m_142448_(y);
            boolean bl = floor = y > 63 && pLevel.m_8055_(pPos.m_7494_()).m_60713_(pFluid.m_60734_());
            if (y > 63 && !this.isWallNecessary(pLevel, (BlockPos)pPos) || this.replaceBlock(pLevel, (BlockPos)pPos, floor ? pConfig.floor().m_213972_(pRandom, (BlockPos)pPos) : pConfig.wall().m_213972_(pRandom, (BlockPos)pPos))) continue;
            return false;
        }
        pPos.m_142448_(pDesiredHeight);
        return true;
    }

    private boolean isWallNecessary(WorldGenLevel pLevel, BlockPos pPos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!pLevel.m_8055_(pPos.m_121945_(direction)).m_60795_()) continue;
            return true;
        }
        return false;
    }

    private boolean replaceBlock(WorldGenLevel pLevel, BlockPos pPos, BlockState pState) {
        if (this.canReplaceBlock(pLevel.m_8055_(pPos))) {
            pLevel.m_7731_(pPos, pState, 2);
            return true;
        }
        return false;
    }

    private boolean canReplaceBlock(BlockState pState) {
        return !pState.m_204336_(StormwardBlockTags.PURELAKE_CANNOT_REPLACE);
    }

    public record Configuration(IntProvider height, IntProvider radius, BlockStateProvider fluid, BlockStateProvider bank, BlockStateProvider wall, BlockStateProvider floor) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.f_146531_.fieldOf("height").forGetter(Configuration::height), (App)IntProvider.f_146531_.fieldOf("radius").forGetter(Configuration::radius), (App)BlockStateProvider.f_68747_.fieldOf("fluid").forGetter(Configuration::fluid), (App)BlockStateProvider.f_68747_.fieldOf("bank").forGetter(Configuration::bank), (App)BlockStateProvider.f_68747_.fieldOf("wall").forGetter(Configuration::wall), (App)BlockStateProvider.f_68747_.fieldOf("floor").forGetter(Configuration::floor)).apply((Applicative)instance, Configuration::new));
    }
}

