/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import us.amon.stormward.block.worldgen.plant.IRosharanPlant;
import us.amon.stormward.block.worldgen.plant.PlantReaction;
import us.amon.stormward.worldgen.biome.StormwardBiomes;

public class RosharFreezeFeature
extends Feature<NoneFeatureConfiguration> {
    public RosharFreezeFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.m_159774_();
        BlockPos blockpos = pContext.m_159777_();
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int x = blockpos.m_123341_() + i;
                int z = blockpos.m_123343_() + j;
                int height = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
                pos1.m_122178_(x, height, z);
                pos2.m_122190_((Vec3i)pos1).m_122175_(Direction.DOWN, 1);
                Holder biome = level.m_204166_((BlockPos)pos1);
                if (RosharFreezeFeature.shouldFreeze((Holder<Biome>)biome, (LevelReader)level, (BlockPos)pos2, false)) {
                    level.m_7731_((BlockPos)pos2, Blocks.f_50126_.m_49966_(), 2);
                }
                if (!RosharFreezeFeature.shouldSnow((Holder<Biome>)biome, (LevelReader)level, (BlockPos)pos1)) continue;
                level.m_7731_((BlockPos)pos1, Blocks.f_50125_.m_49966_(), 2);
                BlockState state = level.m_8055_((BlockPos)pos2);
                if (state.m_61138_((Property)SnowyDirtBlock.f_56637_)) {
                    level.m_7731_((BlockPos)pos2, (BlockState)state.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
                }
                if (!state.m_61138_(IRosharanPlant.PLANT_REACTION)) continue;
                level.m_7731_((BlockPos)pos2, (BlockState)state.m_61124_(IRosharanPlant.PLANT_REACTION, (Comparable)((Object)PlantReaction.RETRACTED)), 2);
            }
        }
        return true;
    }

    public static boolean shouldFreeze(Holder<Biome> pBiome, LevelReader pLevel, BlockPos pPos, boolean pEdge) {
        return !pBiome.m_203565_(StormwardBiomes.HORNEATER_PEAKS) && ((Biome)pBiome.get()).m_47480_(pLevel, pPos, pEdge);
    }

    public static boolean shouldSnow(Holder<Biome> pBiome, LevelReader pLevel, BlockPos pPos) {
        if (!((Biome)pBiome.get()).m_47519_(pLevel, pPos)) {
            return false;
        }
        if (!pBiome.m_203565_(StormwardBiomes.HORNEATER_PEAKS)) {
            return true;
        }
        BlockPos below = pPos.m_7495_();
        return !pLevel.m_46801_(below.m_122024_()) && !pLevel.m_46801_(below.m_122029_()) && !pLevel.m_46801_(below.m_122012_()) && !pLevel.m_46801_(below.m_122019_());
    }
}

