/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public abstract class StructureFeature<FC extends Configuration>
extends Feature<FC> {
    public StructureFeature(Codec<FC> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<FC> pContext) {
        RandomSource random = pContext.m_225041_();
        WorldGenLevel level = pContext.m_159774_();
        BlockPos origin = pContext.m_159777_();
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        Configuration config = (Configuration)pContext.m_159778_();
        StructureTemplateManager structuretemplatemanager = level.m_6018_().m_7654_().m_236738_();
        ResourceLocation structure = config.structures.get(random.m_188503_(config.structures.size()));
        StructureTemplate template = structuretemplatemanager.m_230359_(structure);
        ChunkPos chunk = new ChunkPos(origin);
        BoundingBox boundingBox = new BoundingBox(chunk.m_45604_() - 16, level.m_141937_(), chunk.m_45605_() - 16, chunk.m_45608_() + 16, level.m_151558_(), chunk.m_45609_() + 16);
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rotation).m_74381_(boundingBox).m_230324_(random);
        BlockPos structurePos = template.m_74583_(this.getStructurePos(level, origin, template.m_163808_(rotation), random, config), Mirror.NONE, rotation);
        if (this.canPlaceStructure(level, structurePos, template, settings, config)) {
            settings.m_74394_();
            ((StructureProcessorList)config.processors.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)settings).m_74383_(arg_0));
            template.m_230328_((ServerLevelAccessor)level, structurePos, structurePos, settings, random, 4);
            return true;
        }
        return false;
    }

    protected BlockPos getStructurePos(WorldGenLevel pLevel, BlockPos pOriginPos, Vec3i pSize, RandomSource pRandom, FC pConfig) {
        int x = pOriginPos.m_123341_() - pSize.m_123341_() / 2;
        int y = pOriginPos.m_123342_();
        int z = pOriginPos.m_123343_() - pSize.m_123343_() / 2;
        for (int i = 0; i < pSize.m_123341_(); ++i) {
            for (int j = 0; j < pSize.m_123343_(); ++j) {
                y = Math.min(y, pLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, x + i, z + j));
            }
        }
        y = Math.max(y + ((Configuration)pConfig).offset.m_214085_(pRandom), pLevel.m_141937_() + 10);
        return new BlockPos(x, y, z);
    }

    protected boolean canPlaceStructure(WorldGenLevel pLevel, BlockPos pStructurePos, StructureTemplate pTemplate, StructurePlaceSettings pSettings, FC pConfig) {
        return true;
    }

    public static class Configuration
    implements FeatureConfiguration {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().fieldOf("structures").forGetter(getter -> getter.structures), (App)StructureProcessorType.f_74468_.fieldOf("processors").forGetter(getter -> getter.processors), (App)IntProvider.f_146531_.fieldOf("steepness").forGetter(getter -> getter.offset)).apply((Applicative)instance, Configuration::new));
        protected final List<ResourceLocation> structures;
        protected final Holder<StructureProcessorList> processors;
        protected final IntProvider offset;

        public Configuration(List<ResourceLocation> pStructures, Holder<StructureProcessorList> pProcessors, IntProvider pOffset) {
            this.structures = pStructures;
            this.processors = pProcessors;
            this.offset = pOffset;
        }
    }
}

