/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.mutable.MutableInt;
import us.amon.stormward.worldgen.feature.StructureFeature;

public class UndergroundStructureFeature
extends StructureFeature<Configuration> {
    public UndergroundStructureFeature(Codec<Configuration> pCodec) {
        super(pCodec);
    }

    @Override
    protected boolean canPlaceStructure(WorldGenLevel pLevel, BlockPos pStructurePos, StructureTemplate pTemplate, StructurePlaceSettings pSettings, Configuration pConfig) {
        return UndergroundStructureFeature.countEmptyCorners(pLevel, pTemplate.m_74633_(pSettings, pStructurePos)) <= pConfig.maxEmptyCorners;
    }

    private static int countEmptyCorners(WorldGenLevel pLevel, BoundingBox pBoundingBox) {
        MutableInt mutableint = new MutableInt(0);
        pBoundingBox.m_162380_(p_284921_ -> {
            BlockState blockstate = pLevel.m_8055_(p_284921_);
            if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49991_) || blockstate.m_60713_(Blocks.f_49990_)) {
                mutableint.add(1);
            }
        });
        return mutableint.getValue();
    }

    public static class Configuration
    extends StructureFeature.Configuration {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().fieldOf("structures").forGetter(getter -> getter.structures), (App)StructureProcessorType.f_74468_.fieldOf("processors").forGetter(getter -> getter.processors), (App)Codec.intRange((int)0, (int)7).fieldOf("max_empty_corners").forGetter(getter -> getter.maxEmptyCorners)).apply((Applicative)instance, Configuration::new));
        protected final int maxEmptyCorners;

        public Configuration(List<ResourceLocation> pStructures, Holder<StructureProcessorList> pProcessors, int pMaxEmptyCorners) {
            super(pStructures, pProcessors, (IntProvider)UniformInt.m_146622_((int)-24, (int)-15));
            this.maxEmptyCorners = pMaxEmptyCorners;
        }
    }
}

