/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.provider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseBasedStateProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.worldgen.provider.StormwardBlockStateProviders;

public class StriatedStateProvider
extends NoiseBasedStateProvider {
    public static final Codec<StriatedStateProvider> CODEC = RecordCodecBuilder.create(instance -> StriatedStateProvider.m_191425_((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("threshold").forGetter(getter -> Float.valueOf(getter.threshold)), (App)BlockState.f_61039_.fieldOf("bands").forGetter(getter -> getter.bands), (App)SimpleWeightedRandomList.m_146264_((Codec)BlockState.f_61039_).fieldOf("weighted_list").forGetter(getter -> getter.weightedList))).apply((Applicative)instance, StriatedStateProvider::new));
    private final float threshold;
    private final BlockState bands;
    private final SimpleWeightedRandomList<BlockState> weightedList;

    public StriatedStateProvider(long pSeed, NormalNoise.NoiseParameters pParameters, float pScale, float pThreshold, BlockState pBands, SimpleWeightedRandomList.Builder<BlockState> pWeightedListBuilder) {
        this(pSeed, pParameters, pScale, pThreshold, pBands, (SimpleWeightedRandomList<BlockState>)pWeightedListBuilder.m_146270_());
    }

    public StriatedStateProvider(long pSeed, NormalNoise.NoiseParameters pParameters, float pScale, float pThreshold, BlockState pBands, SimpleWeightedRandomList<BlockState> pWeightedList) {
        super(pSeed, pParameters, pScale);
        this.threshold = pThreshold;
        this.bands = pBands;
        this.weightedList = pWeightedList;
    }

    @NotNull
    protected BlockStateProviderType<?> m_5923_() {
        return (BlockStateProviderType)StormwardBlockStateProviders.STRIATED_STATE_PROVIDER.get();
    }

    @NotNull
    public BlockState m_213972_(@NotNull RandomSource pRandom, @NotNull BlockPos pPos) {
        double value = this.m_191429_(pPos, this.f_191419_);
        if (value < (double)this.threshold) {
            return (BlockState)this.weightedList.m_216820_(pRandom).orElseThrow(IllegalStateException::new);
        }
        return this.bands;
    }

    protected double m_191429_(BlockPos pPos, double pDelta) {
        return this.f_191420_.m_75380_(0.0, (double)pPos.m_123342_() * pDelta, 0.0);
    }
}

