/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.worldgen.provider.TwoStateProvider;
import us.amon.stormward.worldgen.tree.StormwardTrunkPlacers;

public class MarkelTrunkPlacer
extends TrunkPlacer {
    public static final Codec<MarkelTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> MarkelTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("branch_height_percent").forGetter(getter -> Float.valueOf(getter.branchHeightPercent))).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("branch_length_percent").forGetter(getter -> Float.valueOf(getter.branchLengthPercent))).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("branch_chance").forGetter(getter -> Float.valueOf(getter.branchChance))).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("sub_branch_chance").forGetter(getter -> Float.valueOf(getter.subBranchChance))).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("foliage_chance").forGetter(getter -> Float.valueOf(getter.foliageChance))).apply((Applicative)instance, MarkelTrunkPlacer::new));
    protected final float branchHeightPercent;
    protected final float branchLengthPercent;
    protected final float branchChance;
    protected final float subBranchChance;
    protected final float foliageChance;

    public MarkelTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB, float pBranchHeightPercent, float pBranchLengthPercent, float pBranchChance, float pSubBranchChance, float pFoliageChance) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
        this.branchHeightPercent = pBranchHeightPercent;
        this.branchLengthPercent = pBranchLengthPercent;
        this.branchChance = pBranchChance;
        this.subBranchChance = pSubBranchChance;
        this.foliageChance = pFoliageChance;
    }

    @NotNull
    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)StormwardTrunkPlacers.MARKEL.get();
    }

    protected boolean placeBranch(@NotNull BiConsumer<BlockPos, BlockState> pBlockSetter, @NotNull RandomSource pRandom, BlockPos pPos, Direction pDirection, TwoStateProvider trunkProvider, int pLength, Set<BlockPos> pPlacedBlocks, List<FoliagePlacer.FoliageAttachment> pFoliageAttachments) {
        BlockPos branchPos = pPos.m_121945_(pDirection);
        if (pPlacedBlocks.contains(branchPos)) {
            return false;
        }
        for (int i = 0; i < pLength; ++i) {
            BlockPos nextBranchPos;
            pPlacedBlocks.add(branchPos);
            BlockState blockState = (BlockState)trunkProvider.getSecondState(pRandom, pPos).m_61124_((Property)PipeBlock.f_55154_.get(pDirection.m_122424_()), (Comparable)Boolean.valueOf(true));
            int subLength = pLength - i - 1;
            if (this.placeSubBranchOrFoliage(pBlockSetter, pRandom, branchPos, pDirection.m_122427_(), trunkProvider, pRandom.m_216332_(Mth.m_14107_((double)((double)subLength * 0.75)), subLength), pPlacedBlocks, pFoliageAttachments)) {
                blockState = (BlockState)blockState.m_61124_((Property)PipeBlock.f_55154_.get(pDirection.m_122427_()), (Comparable)Boolean.valueOf(true));
            }
            if (this.placeSubBranchOrFoliage(pBlockSetter, pRandom, branchPos, pDirection.m_122428_(), trunkProvider, pRandom.m_216332_(Mth.m_14107_((double)((double)subLength * 0.75)), subLength), pPlacedBlocks, pFoliageAttachments)) {
                blockState = (BlockState)blockState.m_61124_((Property)PipeBlock.f_55154_.get(pDirection.m_122428_()), (Comparable)Boolean.valueOf(true));
            }
            if (this.placeFoliage(pRandom, branchPos, Direction.UP, pPlacedBlocks, pFoliageAttachments)) {
                blockState = (BlockState)blockState.m_61124_((Property)PipeBlock.f_55152_, (Comparable)Boolean.valueOf(true));
            }
            if (pPlacedBlocks.contains(nextBranchPos = branchPos.m_121945_(pDirection))) {
                pBlockSetter.accept(branchPos, blockState);
                return true;
            }
            if (i < pLength - 1 || this.placeFoliage(pRandom, branchPos, pDirection, pPlacedBlocks, pFoliageAttachments)) {
                blockState = (BlockState)blockState.m_61124_((Property)PipeBlock.f_55154_.get(pDirection), (Comparable)Boolean.valueOf(true));
            }
            pBlockSetter.accept(branchPos, blockState);
            branchPos = nextBranchPos;
        }
        return true;
    }

    protected boolean placeSubBranchOrFoliage(@NotNull BiConsumer<BlockPos, BlockState> pBlockSetter, @NotNull RandomSource pRandom, BlockPos pPos, Direction pDirection, TwoStateProvider trunkProvider, int pLength, Set<BlockPos> pPlacedBlocks, List<FoliagePlacer.FoliageAttachment> pFoliageAttachments) {
        if (pLength > 0 && pRandom.m_188501_() <= this.subBranchChance) {
            return this.placeBranch(pBlockSetter, pRandom, pPos, pDirection, trunkProvider, pLength, pPlacedBlocks, pFoliageAttachments);
        }
        return this.placeFoliage(pRandom, pPos, pDirection, pPlacedBlocks, pFoliageAttachments);
    }

    protected boolean placeFoliage(@NotNull RandomSource pRandom, BlockPos pPos, Direction pDirection, Set<BlockPos> pPlacedBlocks, List<FoliagePlacer.FoliageAttachment> pFoliageAttachments) {
        BlockPos foliagePos = pPos.m_121945_(pDirection);
        if (pRandom.m_188501_() <= this.foliageChance && !pPlacedBlocks.contains(foliagePos)) {
            pFoliageAttachments.add(new FoliagePlacer.FoliageAttachment(foliagePos, pDirection.m_122411_(), false));
            pPlacedBlocks.add(foliagePos);
            return true;
        }
        return false;
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@NotNull LevelSimulatedReader pLevel, @NotNull BiConsumer<BlockPos, BlockState> pBlockSetter, @NotNull RandomSource pRandom, int pFreeTreeHeight, @NotNull BlockPos pPos, @NotNull TreeConfiguration pConfig) {
        MarkelTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.m_7495_(), (TreeConfiguration)pConfig);
        return this.placeTrunkWithoutDirt(pLevel, pBlockSetter, pRandom, pFreeTreeHeight, pPos, pConfig);
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunkWithoutDirt(@NotNull LevelSimulatedReader pLevel, @NotNull BiConsumer<BlockPos, BlockState> pBlockSetter, @NotNull RandomSource pRandom, int pFreeTreeHeight, @NotNull BlockPos pPos, @NotNull TreeConfiguration pConfig) {
        TwoStateProvider trunkProvider = (TwoStateProvider)pConfig.f_68185_;
        HashSet<BlockPos> placedBlocks = new HashSet<BlockPos>();
        ArrayList<FoliagePlacer.FoliageAttachment> foliageAttachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int branchStartHeight = Mth.m_14143_((float)((float)pFreeTreeHeight * this.branchHeightPercent));
        int maxBranchLength = Mth.m_14165_((double)((double)pFreeTreeHeight * (double)this.branchLengthPercent));
        for (int i = pFreeTreeHeight - 1; i >= 0; --i) {
            BlockPos logPos = pPos.m_6630_(i);
            this.m_226187_(pLevel, pBlockSetter, pRandom, logPos, pConfig);
            placedBlocks.add(logPos);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (i < branchStartHeight) continue;
                if (pRandom.m_188501_() <= this.branchChance) {
                    double percent = (double)(i - branchStartHeight) / (double)(pFreeTreeHeight - branchStartHeight);
                    double num = percent * 1.5 - 0.5;
                    int length = Mth.m_14165_((double)((1.0 - num * num) * (double)maxBranchLength));
                    this.placeBranch(pBlockSetter, pRandom, logPos, direction, trunkProvider, pRandom.m_216332_(Mth.m_14107_((double)((double)length * 0.75)), length), placedBlocks, foliageAttachments);
                    continue;
                }
                this.placeFoliage(pRandom, logPos, direction, placedBlocks, foliageAttachments);
            }
        }
        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_6630_(pFreeTreeHeight), Direction.UP.m_122411_(), false));
        return foliageAttachments;
    }
}

