/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.worldgen.wood.MarkelLogBlock;
import us.amon.stormward.worldgen.provider.ThreeStateProvider;
import us.amon.stormward.worldgen.tree.MarkelTrunkPlacer;
import us.amon.stormward.worldgen.tree.StormwardTrunkPlacers;

public class PurelakeMarkelTrunkPlacer
extends MarkelTrunkPlacer {
    public static final Codec<PurelakeMarkelTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(p_70314_ -> p_70314_.f_70263_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(p_70312_ -> p_70312_.f_70264_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(p_70308_ -> p_70308_.f_70265_), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("branch_height_percent").forGetter(getter -> Float.valueOf(getter.branchHeightPercent)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("branch_length_percent").forGetter(getter -> Float.valueOf(getter.branchLengthPercent)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("branch_chance").forGetter(getter -> Float.valueOf(getter.branchChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("sub_branch_chance").forGetter(getter -> Float.valueOf(getter.subBranchChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("foliage_chance").forGetter(getter -> Float.valueOf(getter.foliageChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("root_chance").forGetter(getter -> Float.valueOf(getter.rootChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("small_chance").forGetter(getter -> Float.valueOf(getter.smallChance)), (App)IntProvider.f_146531_.fieldOf("root_length").forGetter(getter -> getter.rootLength), (App)IntProvider.f_146531_.fieldOf("root_height").forGetter(getter -> getter.rootHeight)).apply((Applicative)instance, PurelakeMarkelTrunkPlacer::new));
    protected final float rootChance;
    protected final float smallChance;
    protected final IntProvider rootLength;
    protected final IntProvider rootHeight;

    public PurelakeMarkelTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB, float pBranchHeightPercent, float pBranchLengthPercent, float pBranchChance, float pSubBranchChance, float pFoliageChance, float pRootChance, float pSmallChance, IntProvider pRootLength, IntProvider pRootHeight) {
        super(pBaseHeight, pHeightRandA, pHeightRandB, pBranchHeightPercent, pBranchLengthPercent, pBranchChance, pSubBranchChance, pFoliageChance);
        this.rootChance = pRootChance;
        this.smallChance = pSmallChance;
        this.rootLength = pRootLength;
        this.rootHeight = pRootHeight;
    }

    @Override
    @NotNull
    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)StormwardTrunkPlacers.PURELAKE_MARKEL.get();
    }

    protected boolean placeRoot(@NotNull BiConsumer<BlockPos, BlockState> pBlockSetter, @NotNull RandomSource pRandom, BlockPos pPos, Direction pDirection, ThreeStateProvider trunkProvider, int pLength, int pHeight, boolean pSmall, Set<BlockPos> pPlacedBlocks) {
        BlockPos rootPos = pPos.m_121945_(pDirection);
        if (pPlacedBlocks.contains(rootPos)) {
            return false;
        }
        pPlacedBlocks.add(rootPos);
        BlockState rootState = pSmall ? (BlockState)trunkProvider.getSecondState(pRandom, rootPos).m_61124_((Property)PipeBlock.f_55154_.get(pDirection.m_122424_()), (Comparable)Boolean.valueOf(true)) : (BlockState)trunkProvider.getFirstState(pRandom, rootPos).m_61124_((Property)MarkelLogBlock.f_55923_, (Comparable)pDirection.m_122434_());
        if (pLength > 0) {
            boolean newSmall;
            boolean bl = newSmall = pSmall || pRandom.m_188501_() < this.smallChance;
            if (this.placeRoot(pBlockSetter, pRandom, rootPos, pDirection, trunkProvider, pLength - 1, pHeight, newSmall, pPlacedBlocks)) {
                if (pSmall) {
                    rootState = (BlockState)rootState.m_61124_((Property)PipeBlock.f_55154_.get(pDirection), (Comparable)Boolean.valueOf(true));
                } else if (newSmall) {
                    rootState = trunkProvider.getThirdState(pRandom, rootPos);
                }
            } else {
                pLength = 0;
            }
        }
        if (pLength > 1) {
            if (pRandom.m_188501_() < this.rootChance && this.placeRoot(pBlockSetter, pRandom, rootPos, pDirection.m_122427_(), trunkProvider, pLength - 1, pHeight, true, pPlacedBlocks) && pSmall) {
                rootState = (BlockState)rootState.m_61124_((Property)PipeBlock.f_55154_.get(pDirection.m_122427_()), (Comparable)Boolean.valueOf(true));
            }
            if (pRandom.m_188501_() < this.rootChance && this.placeRoot(pBlockSetter, pRandom, rootPos, pDirection.m_122428_(), trunkProvider, pLength - 1, pHeight, true, pPlacedBlocks) && pSmall) {
                rootState = (BlockState)rootState.m_61124_((Property)PipeBlock.f_55154_.get(pDirection.m_122428_()), (Comparable)Boolean.valueOf(true));
            }
        }
        if (pLength <= 0) {
            if (pHeight > 0 && this.placeRoot(pBlockSetter, pRandom, rootPos, Direction.DOWN, trunkProvider, 0, pHeight - 1, pSmall, pPlacedBlocks) && !pSmall && pDirection != Direction.DOWN) {
                rootState = trunkProvider.getThirdState(pRandom, rootPos);
            }
            if (pSmall) {
                rootState = (BlockState)rootState.m_61124_((Property)PipeBlock.f_55154_.get(Direction.DOWN), (Comparable)Boolean.valueOf(true));
            }
        }
        pBlockSetter.accept(rootPos, rootState);
        return true;
    }

    @Override
    @NotNull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@NotNull LevelSimulatedReader pLevel, @NotNull BiConsumer<BlockPos, BlockState> pBlockSetter, @NotNull RandomSource pRandom, int pFreeTreeHeight, @NotNull BlockPos pPos, @NotNull TreeConfiguration pConfig) {
        ThreeStateProvider trunkProvider = (ThreeStateProvider)pConfig.f_68185_;
        int height = this.rootHeight.m_214085_(pRandom);
        BlockPos startPos = pPos.m_6630_(height);
        HashSet<BlockPos> placedBlocks = new HashSet<BlockPos>();
        pBlockSetter.accept(startPos, trunkProvider.getThirdState(pRandom, startPos));
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.placeRoot(pBlockSetter, pRandom, startPos, direction, trunkProvider, this.rootLength.m_214085_(pRandom) - 1, height, pRandom.m_188500_() < (double)this.smallChance, placedBlocks);
        }
        return this.placeTrunkWithoutDirt(pLevel, pBlockSetter, pRandom, pFreeTreeHeight, startPos, pConfig);
    }
}

