/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.worldgen.plant.StumpweightLeavesBlock;
import us.amon.stormward.worldgen.tree.StormwardFoliagePlacers;

public class StumpweightFoliagePlacer
extends FoliagePlacer {
    public static final Codec<StumpweightFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> StumpweightFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, StumpweightFoliagePlacer::new));

    public StumpweightFoliagePlacer(IntProvider pRadius, IntProvider pOffset) {
        super(pRadius, pOffset);
    }

    @NotNull
    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)StormwardFoliagePlacers.STUMPWEIGHT.get();
    }

    protected void m_213633_(@NotNull LevelSimulatedReader pLevel, @NotNull FoliagePlacer.FoliageSetter pBlockSetter, @NotNull RandomSource pRandom, @NotNull TreeConfiguration pConfig, int pMaxFreeTreeHeight, @NotNull FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        BlockPos pos = pAttachment.m_161451_();
        int height = pAttachment.m_68589_();
        for (int i = 0; i < height; ++i) {
            BlockPos leafPos = pos.m_6630_(i);
            if (!((double)(i + 1) / (double)height > 0.2) || !TreeFeature.m_67272_((LevelSimulatedReader)pLevel, (BlockPos)leafPos)) continue;
            BlockState blockstate = (BlockState)pConfig.f_161213_.m_213972_(pRandom, leafPos).m_61124_((Property)StumpweightLeavesBlock.FACING, (Comparable)Direction.WEST);
            pBlockSetter.m_271838_(leafPos, blockstate);
        }
    }

    public int m_214116_(@NotNull RandomSource pRandom, int pHeight, @NotNull TreeConfiguration pConfig) {
        return 0;
    }

    protected boolean m_214203_(@NotNull RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return false;
    }
}

