#version 150

#moj_import <matrix.glsl>

uniform sampler2D Sampler0;
uniform sampler2D Sampler1;

uniform float GameTime;
uniform int HighsprenLayers;

in vec4 texProj0;

const mat4 SCALE_TRANSLATE = mat4(
    0.5, 0.0, 0.0, 0.25,
    0.0, 0.5, 0.0, 0.25,
    0.0, 0.0, 1.0, 0.0,
    0.0, 0.0, 0.0, 1.0
);

mat4 highspren_layer(float layer) {
    mat4 translate = mat4(
    1.0, 0.0, 0.0, 17.0 / layer,
    0.0, 1.0, 0.0, (2.0 + layer / 1.5),
    0.0, 0.0, 1.0, 0.0,
    0.0, 0.0, 0.0, 1.0
    );

    mat2 scale = mat2((4.5 - layer / 2.0));

    return mat4(scale) * SCALE_TRANSLATE;
}

out vec4 fragColor;

void main() {
    vec3 color = textureProj(Sampler0, texProj0).rgb;
    for (int i = 0; i < HighsprenLayers; i++) {
        float alpha = (0.5 + (i / (HighsprenLayers - 1)) * 0.5) * ((1.2 + sin((GameTime + i) * 1000.0) * 0.8) / 2.0);
        color += textureProj(Sampler1, texProj0 * highspren_layer(float(i + 1))).rgb * alpha;
    }
    fragColor = vec4(color, 1.0);
}
