/*
 * Decompiled with CFR 0.152.
 */
package me.nouridin.resourcesTracker.commands;

import java.util.Arrays;
import me.nouridin.resourcesTracker.data.StorageManager;
import me.nouridin.resourcesTracker.views.StatsBook;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class StatsCommand
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final StorageManager storageManager;

    public StatsCommand(JavaPlugin plugin, StorageManager storageManager) {
        this.plugin = plugin;
        this.storageManager = storageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (this.plugin.getConfig().getBoolean("Only-OP") && !player.isOp()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("notifications")) {
            if (args.length == 2) {
                if (args[1].equalsIgnoreCase("enable")) {
                    this.storageManager.setNotificationsDisabled(player.getUniqueId(), false);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Notifications have been enabled.");
                } else if (args[1].equalsIgnoreCase("disable")) {
                    this.storageManager.setNotificationsDisabled(player.getUniqueId(), true);
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Notifications have been disabled.");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rstats notifications <enable/disable>");
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rstats notifications <enable/disable>");
            }
            return true;
        }
        if (args.length >= 1) {
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            String searchTerm = null;
            if (args.length > 1) {
                searchTerm = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            }
            ItemStack statsBook = new StatsBook(this.storageManager, target).createBook(player, searchTerm);
            player.getInventory().addItem(new ItemStack[]{statsBook});
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "A statistics book for " + target.getName() + " has been added to your inventory.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rstats <player> [search term] or /rstats notifications <enable/disable>");
        return true;
    }
}

