/*
 * Decompiled with CFR 0.152.
 */
package me.nouridin.resourcesTracker.data;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DataManager {
    private final JavaPlugin plugin;
    private final Map<UUID, Map<Material, Integer>> brokenBlocks = new HashMap<UUID, Map<Material, Integer>>();
    private final Map<UUID, Map<Material, Integer>> pickedUpItems = new HashMap<UUID, Map<Material, Integer>>();
    private final Set<UUID> notificationsDisabled = new HashSet<UUID>();

    public DataManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void addBrokenBlock(UUID playerUUID, Material blockType) {
        Map playerBlocks = this.brokenBlocks.computeIfAbsent(playerUUID, k -> new HashMap());
        playerBlocks.put(blockType, playerBlocks.getOrDefault(blockType, 0) + 1);
    }

    public void addPickedUpItem(UUID playerUUID, Material itemType, int amount) {
        Map playerItems = this.pickedUpItems.computeIfAbsent(playerUUID, k -> new HashMap());
        playerItems.put(itemType, playerItems.getOrDefault(itemType, 0) + amount);
    }

    public Map<Material, Integer> getBrokenBlocks(UUID playerUUID) {
        return this.brokenBlocks.getOrDefault(playerUUID, new HashMap());
    }

    public Map<Material, Integer> getPickedUpItems(UUID playerUUID) {
        return this.pickedUpItems.getOrDefault(playerUUID, new HashMap());
    }

    public void setNotificationsDisabled(UUID playerUUID, boolean disabled) {
        if (disabled) {
            this.notificationsDisabled.add(playerUUID);
        } else {
            this.notificationsDisabled.remove(playerUUID);
        }
    }

    public boolean areNotificationsDisabled(UUID playerUUID) {
        return this.notificationsDisabled.contains(playerUUID);
    }

    public void saveData() {
        File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)dataFile);
        config.set("broken-blocks", null);
        config.set("picked-up-items", null);
        for (Map.Entry<UUID, Map<Material, Integer>> entry : this.brokenBlocks.entrySet()) {
            for (Map.Entry<Material, Integer> dataEntry : entry.getValue().entrySet()) {
                config.set("broken-blocks." + entry.getKey().toString() + "." + dataEntry.getKey().toString(), (Object)dataEntry.getValue());
            }
        }
        for (Map.Entry<UUID, Map<Material, Integer>> entry : this.pickedUpItems.entrySet()) {
            for (Map.Entry<Material, Integer> dataEntry : entry.getValue().entrySet()) {
                config.set("picked-up-items." + entry.getKey().toString() + "." + dataEntry.getKey().toString(), (Object)dataEntry.getValue());
            }
        }
        config.set("notifications-disabled", this.notificationsDisabled.stream().map(UUID::toString).collect(Collectors.toList()));
        try {
            config.save(dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save data to data.yml!");
            e.printStackTrace();
        }
    }

    public void loadData() {
        ConfigurationSection pickedUpItemsSection;
        File dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        if (!dataFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)dataFile);
        ConfigurationSection brokenBlocksSection = config.getConfigurationSection("broken-blocks");
        if (brokenBlocksSection != null) {
            for (String uuidString2 : brokenBlocksSection.getKeys(false)) {
                UUID uuid = UUID.fromString(uuidString2);
                ConfigurationSection playerSection = brokenBlocksSection.getConfigurationSection(uuidString2);
                if (playerSection == null) continue;
                HashMap<Material, Integer> playerBlocks = new HashMap<Material, Integer>();
                for (String materialString : playerSection.getKeys(false)) {
                    Material material = Material.getMaterial((String)materialString);
                    if (material == null) continue;
                    playerBlocks.put(material, playerSection.getInt(materialString));
                }
                this.brokenBlocks.put(uuid, playerBlocks);
            }
        }
        if ((pickedUpItemsSection = config.getConfigurationSection("picked-up-items")) != null) {
            for (String uuidString3 : pickedUpItemsSection.getKeys(false)) {
                UUID uuid = UUID.fromString(uuidString3);
                ConfigurationSection playerSection = pickedUpItemsSection.getConfigurationSection(uuidString3);
                if (playerSection == null) continue;
                HashMap<Material, Integer> playerItems = new HashMap<Material, Integer>();
                for (String materialString : playerSection.getKeys(false)) {
                    Material material = Material.getMaterial((String)materialString);
                    if (material == null) continue;
                    playerItems.put(material, playerSection.getInt(materialString));
                }
                this.pickedUpItems.put(uuid, playerItems);
            }
        }
        this.notificationsDisabled.clear();
        config.getStringList("notifications-disabled").forEach(uuidString -> this.notificationsDisabled.add(UUID.fromString(uuidString)));
    }
}

