/*
 * Decompiled with CFR 0.152.
 */
package me.nouridin.resourcesTracker.listeners;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import me.nouridin.resourcesTracker.data.StorageManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class BlockBreakListener
implements Listener {
    private final JavaPlugin plugin;
    private final StorageManager storageManager;
    private final List<Material> notifyMaterials;

    public BlockBreakListener(JavaPlugin plugin, StorageManager storageManager) {
        this.plugin = plugin;
        this.storageManager = storageManager;
        this.notifyMaterials = plugin.getConfig().getStringList("notify-on").stream().map(Material::getMaterial).collect(Collectors.toList());
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Material blockType = event.getBlock().getType();
        this.storageManager.addBrokenBlock(player.getUniqueId(), blockType);
        if (this.notifyMaterials.contains(blockType)) {
            Location loc = event.getBlock().getLocation();
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String[] messages = new String[]{String.valueOf(ChatColor.DARK_RED) + "[" + this.plugin.getName() + "] " + String.valueOf(ChatColor.YELLOW) + player.getName() + " broke " + String.valueOf(blockType), String.valueOf(ChatColor.GRAY) + "--------------------", String.valueOf(ChatColor.WHITE) + "X: " + String.valueOf(ChatColor.AQUA) + loc.getBlockX(), String.valueOf(ChatColor.WHITE) + "Y: " + String.valueOf(ChatColor.AQUA) + loc.getBlockY(), String.valueOf(ChatColor.WHITE) + "Z: " + String.valueOf(ChatColor.AQUA) + loc.getBlockZ(), String.valueOf(ChatColor.GRAY) + "--------------------", String.valueOf(ChatColor.DARK_GRAY) + date};
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.hasPermission("resourcestracker.notify") || this.storageManager.areNotificationsDisabled(onlinePlayer.getUniqueId())) continue;
                onlinePlayer.sendMessage(messages);
            }
        }
    }
}

