/*
 * Decompiled with CFR 0.152.
 */
package me.nouridin.resourcesTracker.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final String currentVersion;
    private static final String API_URL = "https://api.modrinth.com/v2/project/resources-tracker/version";
    private static boolean updateAvailable = false;
    private static String latestVersion = "";

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public void check() {
        if (!this.plugin.getConfig().getBoolean("check-for-updates", true)) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL url = new URL(API_URL);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "ResourcesTracker/UpdateChecker");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    Pattern pattern = Pattern.compile("\"version_number\":\"(.*?)\"");
                    Matcher matcher = pattern.matcher(response.toString());
                    if (matcher.find() && !this.currentVersion.equalsIgnoreCase(latestVersion = matcher.group(1))) {
                        updateAvailable = true;
                        this.plugin.getLogger().info("A new version of ResourcesTracker is available: " + latestVersion);
                        this.notifyAdmins();
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not check for updates: " + e.getMessage());
            }
        });
    }

    private void notifyAdmins() {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOp()) continue;
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "A new version of " + String.valueOf(ChatColor.BOLD) + "ResourcesTracker" + String.valueOf(ChatColor.GREEN) + " is available: " + String.valueOf(ChatColor.YELLOW) + latestVersion);
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "You can download it from: " + String.valueOf(ChatColor.AQUA) + "https://modrinth.com/project/resources-tracker");
            }
        });
    }

    public static boolean isUpdateAvailable() {
        return updateAvailable;
    }

    public static String getLatestVersion() {
        return latestVersion;
    }
}

