/*
 * Decompiled with CFR 0.152.
 */
package me.nouridin.resourcesTracker.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import me.nouridin.resourcesTracker.data.StorageManager;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class StatsBook {
    private final StorageManager storageManager;
    private final Player target;

    public StatsBook(StorageManager storageManager, Player target) {
        this.storageManager = storageManager;
        this.target = target;
    }

    public ItemStack createBook(Player generator, String searchTerm) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        String title = searchTerm != null && !searchTerm.isEmpty() ? "Stats: " + this.target.getName() + " ('" + searchTerm + "')" : "Stats: " + this.target.getName();
        meta.setTitle(title);
        meta.setAuthor(generator.getName());
        ArrayList<BaseComponent[]> pages = new ArrayList<BaseComponent[]>();
        TextComponent titleComponent = new TextComponent(title + "\n");
        titleComponent.setColor(ChatColor.DARK_BLUE);
        titleComponent.setBold(Boolean.valueOf(true));
        TextComponent dateComponent = new TextComponent("Generated on:\n" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\n\n");
        dateComponent.setColor(ChatColor.GRAY);
        TextComponent generatorComponent = new TextComponent("By: " + generator.getName());
        generatorComponent.setColor(ChatColor.DARK_GRAY);
        generatorComponent.setItalic(Boolean.valueOf(true));
        pages.add(new BaseComponent[]{titleComponent, dateComponent, generatorComponent});
        this.addStatPages(pages, "Broken Blocks", this.storageManager.getBrokenBlocks(this.target.getUniqueId(), searchTerm));
        this.addStatPages(pages, "Picked-Up Items", this.storageManager.getPickedUpItems(this.target.getUniqueId(), searchTerm));
        meta.spigot().setPages(pages);
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    private void addStatPages(List<BaseComponent[]> pages, String title, Map<Material, Integer> data) {
        TextComponent titleComponent = new TextComponent(title + "\n\n");
        titleComponent.setColor(ChatColor.DARK_RED);
        titleComponent.setBold(Boolean.valueOf(true));
        if (data.isEmpty()) {
            TextComponent emptyComponent = new TextComponent("None");
            emptyComponent.setColor(ChatColor.GRAY);
            pages.add(new BaseComponent[]{titleComponent, emptyComponent});
            return;
        }
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        components.add(titleComponent);
        int lines = 1;
        for (Map.Entry<Material, Integer> entry : data.entrySet()) {
            TextComponent material = new TextComponent(entry.getKey().toString().replace("_", " ").toLowerCase() + ": ");
            material.setColor(ChatColor.BLACK);
            TextComponent count = new TextComponent(String.valueOf(entry.getValue()) + "\n");
            count.setColor(ChatColor.DARK_BLUE);
            components.add(material);
            components.add(count);
            if (++lines < 7) continue;
            pages.add(components.toArray(new BaseComponent[0]));
            components.clear();
            lines = 0;
        }
        if (!components.isEmpty()) {
            pages.add(components.toArray(new BaseComponent[0]));
        }
    }
}

