/*
 * Decompiled with CFR 0.152.
 */
package me.nouridin.resourcesTracker.views;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.nouridin.resourcesTracker.data.DataManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class StatsGUI
implements InventoryHolder {
    private final DataManager dataManager;
    private final Player target;
    private final Inventory inventory;
    private int currentPage = 0;
    private View currentView = View.BROKEN_BLOCKS;

    public StatsGUI(DataManager dataManager, Player target) {
        this.dataManager = dataManager;
        this.target = target;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)("Stats: " + target.getName()));
    }

    public void open(Player player) {
        this.updateGUI();
        player.openInventory(this.inventory);
    }

    private void updateGUI() {
        this.inventory.clear();
        Map<Material, Integer> data = this.currentView == View.BROKEN_BLOCKS ? this.dataManager.getBrokenBlocks(this.target.getUniqueId()) : this.dataManager.getPickedUpItems(this.target.getUniqueId());
        List sortedData = data.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
        int maxItemsPerPage = 45;
        int startIndex = this.currentPage * maxItemsPerPage;
        int endIndex = Math.min(startIndex + maxItemsPerPage, sortedData.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Map.Entry entry = (Map.Entry)sortedData.get(i);
            ItemStack item = new ItemStack((Material)entry.getKey());
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(((Material)entry.getKey()).toString());
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                lore.add((CallSite)((Object)((this.currentView == View.BROKEN_BLOCKS ? "Broken: " : "Picked Up: ") + String.valueOf(entry.getValue()))));
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            this.inventory.setItem(i - startIndex, item);
        }
        int maxPages = (int)Math.ceil((double)sortedData.size() / (double)maxItemsPerPage);
        if (this.currentPage > 0) {
            this.inventory.setItem(48, this.createControlButton(Material.ARROW, "Previous Page"));
        }
        String switchButtonName = this.currentView == View.BROKEN_BLOCKS ? "View Picked-Up Items" : "View Broken Blocks";
        Material switchButtonMaterial = this.currentView == View.BROKEN_BLOCKS ? Material.HOPPER : Material.DIAMOND_PICKAXE;
        this.inventory.setItem(49, this.createControlButton(switchButtonMaterial, switchButtonName));
        if (this.currentPage < maxPages - 1) {
            this.inventory.setItem(50, this.createControlButton(Material.ARROW, "Next Page"));
        }
    }

    private ItemStack createControlButton(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    public void nextPage(Player player) {
        ++this.currentPage;
        this.updateGUI();
    }

    public void previousPage(Player player) {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.updateGUI();
        }
    }

    public void switchView(Player player) {
        this.currentView = this.currentView == View.BROKEN_BLOCKS ? View.PICKED_UP_ITEMS : View.BROKEN_BLOCKS;
        this.currentPage = 0;
        this.updateGUI();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private static enum View {
        BROKEN_BLOCKS,
        PICKED_UP_ITEMS;

    }
}

