/*
 * Decompiled with CFR 0.152.
 */
package net.sterbendes.greeneries;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Contract;

public interface GreeneriesPlatform {
    default public <T> Holder<T> register(Registry<T> registry, ResourceLocation rl, Supplier<T> value) {
        return Registry.registerForHolder(registry, (ResourceLocation)rl, value.get());
    }

    @Contract(value=" -> new", pure=true)
    public CreativeModeTab.Builder creativeTabBuilder();

    public void setRenderLayer(Supplier<Block> var1, RenderType var2);

    public void onServerStart(Consumer<MinecraftServer> var1);

    public void onClientStart(Consumer<Minecraft> var1);

    public void setBlockColor(Supplier<Block> var1, BlockColor var2);

    public void setItemColor(Supplier<ItemLike> var1, ItemColor var2);

    default public boolean isClient() {
        try {
            Class.forName("net.minecraft.client.Minecraft");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

