/*
 * Decompiled with CFR 0.152.
 */
package net.sterbendes.greeneries.blocks;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.sterbendes.greeneries.GreeneriesMod;
import net.sterbendes.greeneries.blocks.ReedBlock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ModBlocks {
    private static final Map<String, Holder<Block>> allGreeneriesBlocks = new LinkedHashMap<String, Holder<Block>>();
    public static final BlockColor VARYING_GRASS_BLOCK_COLOR = (blockState, blockAndTintGetter, blockPos, i) -> {
        int color;
        int n = color = blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : GrassColor.getDefaultColor();
        if (blockPos == null) {
            return color;
        }
        RandomSource randomSource = RandomSource.create((long)BlockPos.asLong((int)blockPos.getX(), (int)0, (int)blockPos.getZ()));
        int rand1 = randomSource.nextInt() / 22 >> 8 & 0xFF0000;
        int rand2 = randomSource.nextInt() / 18 >> 16 & 0xFF00;
        int rand3 = randomSource.nextInt() / 24 >> 24 & 0xFF;
        return color + rand1 + rand2 + rand3;
    };
    public static final BlockColor VARYING_FERN_BLOCK_COLOR = (blockState, blockAndTintGetter, blockPos, i) -> {
        int color;
        int n = color = blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : GrassColor.getDefaultColor();
        if (blockPos == null) {
            return color;
        }
        RandomSource randomSource = RandomSource.create((long)BlockPos.asLong((int)blockPos.getX(), (int)0, (int)blockPos.getZ()));
        int rand1 = randomSource.nextInt() / 22 >> 8 & 0xFF0000;
        int rand2 = randomSource.nextInt() / 18 >> 16 & 0xFF00;
        int rand3 = randomSource.nextInt() / 24 >> 24 & 0xFF;
        return color + rand1 + rand2 + rand3;
    };
    public static final BlockColor FOLIAGE_COLOR = (blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos) : FoliageColor.getDefaultColor();
    public static final ItemColor GRASS_ITEM_COLOR = (stack, i) -> GrassColor.getDefaultColor();

    public static void registerVariants(String name, String ... variants) {
        ModBlocks.registerVariants(name, VARYING_GRASS_BLOCK_COLOR, GRASS_ITEM_COLOR, variants);
    }

    public static void registerVariants(String name, @Nullable BlockColor blockTint, @Nullable ItemColor itemTint, String ... variants) {
        for (String variant : variants) {
            ModBlocks.register(variant + "_" + name, blockTint, itemTint, () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS)){});
        }
    }

    private static void register(String name, @Nullable BlockColor blockTint, @Nullable ItemColor itemTint, Supplier<Block> blockSupplier) {
        Holder<Block> holder = GreeneriesMod.register(name, BuiltInRegistries.BLOCK, blockSupplier);
        GreeneriesMod.register(name, BuiltInRegistries.ITEM, () -> new BlockItem((Block)holder.value(), new Item.Properties()));
        GreeneriesMod.platform.setRenderLayer(() -> holder.value(), RenderType.cutout());
        if (blockTint != null) {
            GreeneriesMod.platform.setBlockColor(() -> holder.value(), blockTint);
        }
        if (itemTint != null) {
            GreeneriesMod.platform.setItemColor(() -> holder.value(), itemTint);
        }
        allGreeneriesBlocks.put(name, holder);
    }

    public static Collection<Holder<Block>> getAllGreeneriesBlocks() {
        return allGreeneriesBlocks.values();
    }

    public static Holder<Block> get(String name) {
        return allGreeneriesBlocks.get(name);
    }

    @ApiStatus.Internal
    public static void init() {
    }

    static {
        ModBlocks.registerVariants("grass", "very_short", "bushy", "medium");
        ModBlocks.registerVariants("red_fescue", "very_short", "short", "bushy", "medium");
        ModBlocks.registerVariants("common_bent", VARYING_GRASS_BLOCK_COLOR, null, "very_short", "short", "bushy");
        ModBlocks.registerVariants("blue_grass", "very_short", "short", "bushy");
        ModBlocks.register("medium_eagle_fern", VARYING_FERN_BLOCK_COLOR, GRASS_ITEM_COLOR, () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FERN)){});
        ModBlocks.register("tall_eagle_fern", VARYING_FERN_BLOCK_COLOR, GRASS_ITEM_COLOR, () -> new DoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LARGE_FERN)));
        ModBlocks.register("short_royal_fern", VARYING_FERN_BLOCK_COLOR, null, () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FERN)){});
        ModBlocks.register("medium_royal_fern", VARYING_FERN_BLOCK_COLOR, null, () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FERN)){});
        ModBlocks.register("tall_royal_fern", VARYING_FERN_BLOCK_COLOR, null, () -> new DoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LARGE_FERN)){});
        ModBlocks.register("cattail", FOLIAGE_COLOR, null, () -> new ReedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_SEAGRASS)));
        ModBlocks.register("reed", FOLIAGE_COLOR, null, () -> new ReedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_SEAGRASS)));
    }
}

