/*
 * Decompiled with CFR 0.152.
 */
package net.sterbendes.greeneries.neoforge;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.sterbendes.greeneries.GreeneriesMod;
import net.sterbendes.greeneries.GreeneriesPlatform;
import net.sterbendes.greeneries.neoforge.data.DataGenerator;
import org.jetbrains.annotations.UnknownNullability;

@Mod(value="greeneries")
public class ModNeoforge {
    public static @UnknownNullability IEventBus modEventBus;

    public ModNeoforge(IEventBus modEventBus) {
        ModNeoforge.modEventBus = modEventBus;
        modEventBus.addListener(GatherDataEvent.class, DataGenerator::onGatherData);
        GreeneriesMod.init(new GreeneriesNeoforgePlatform());
    }

    private static class GreeneriesNeoforgePlatform
    implements GreeneriesPlatform {
        private GreeneriesNeoforgePlatform() {
        }

        @Override
        public <T> Holder<T> register(Registry<T> registry, ResourceLocation rl, Supplier<T> value) {
            modEventBus.addListener(event -> event.register(registry.key(), rl, value));
            return DeferredHolder.create((ResourceKey)registry.key(), (ResourceLocation)rl);
        }

        @Override
        public CreativeModeTab.Builder creativeTabBuilder() {
            return CreativeModeTab.builder();
        }

        @Override
        public void onServerStart(Consumer<MinecraftServer> consumer) {
            NeoForge.EVENT_BUS.addListener(ServerStartingEvent.class, event -> consumer.accept(event.getServer()));
        }

        @Override
        public void onClientStart(Consumer<Minecraft> consumer) {
            modEventBus.addListener(FMLClientSetupEvent.class, event -> consumer.accept(Minecraft.getInstance()));
        }

        @Override
        public void setRenderLayer(Supplier<Block> block, RenderType renderType) {
            this.onClientStart(mc -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)renderType));
        }

        @Override
        public void setBlockColor(Supplier<Block> block, BlockColor color) {
            modEventBus.addListener(RegisterColorHandlersEvent.Block.class, event -> event.register(color, new Block[]{(Block)block.get()}));
        }

        @Override
        public void setItemColor(Supplier<ItemLike> item, ItemColor itemColor) {
            modEventBus.addListener(RegisterColorHandlersEvent.Item.class, event -> event.register(itemColor, new ItemLike[]{(ItemLike)item.get()}));
        }
    }
}

